/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.GetIndexTemplateResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetIndexTemplateRequest
extends RequestBase {
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean includeTypeName;
    @Nullable
    private final Boolean local;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String name;
    public static final Endpoint<GetIndexTemplateRequest, GetIndexTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetIndexTemplateRequest, GetIndexTemplateResponse>("es/indices.get_index_template", request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.includeTypeName != null) {
            params.put("include_type_name", String.valueOf(request.includeTypeName));
        }
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetIndexTemplateResponse._DESERIALIZER);

    private GetIndexTemplateRequest(Builder builder) {
        this.flatSettings = builder.flatSettings;
        this.includeTypeName = builder.includeTypeName;
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
        this.name = builder.name;
    }

    public static GetIndexTemplateRequest of(Function<Builder, ObjectBuilder<GetIndexTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public final Boolean includeTypeName() {
        return this.includeTypeName;
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetIndexTemplateRequest> {
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean includeTypeName;
        @Nullable
        private Boolean local;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String name;

        public final Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public final Builder includeTypeName(@Nullable Boolean value) {
            this.includeTypeName = value;
            return this;
        }

        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        public GetIndexTemplateRequest build() {
            this._checkSingleUse();
            return new GetIndexTemplateRequest(this);
        }
    }
}

