/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.move_to_step;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class StepKey
implements JsonpSerializable {
    private final String action;
    private final String name;
    private final String phase;
    public static final JsonpDeserializer<StepKey> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StepKey::setupStepKeyDeserializer);

    private StepKey(Builder builder) {
        this.action = ApiTypeHelper.requireNonNull(builder.action, this, "action");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.phase = ApiTypeHelper.requireNonNull(builder.phase, this, "phase");
    }

    public static StepKey of(Function<Builder, ObjectBuilder<StepKey>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String action() {
        return this.action;
    }

    public final String name() {
        return this.name;
    }

    public final String phase() {
        return this.phase;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("phase");
        generator.write(this.phase);
    }

    protected static void setupStepKeyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::phase, JsonpDeserializer.stringDeserializer(), "phase");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<StepKey> {
        private String action;
        private String name;
        private String phase;

        public final Builder action(String value) {
            this.action = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder phase(String value) {
            this.phase = value;
            return this;
        }

        @Override
        public StepKey build() {
            this._checkSingleUse();
            return new StepKey(this);
        }
    }
}

