/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.get_lifecycle;

import co.elastic.clients.elasticsearch.ilm.IlmPolicy;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Lifecycle
implements JsonpSerializable {
    private final String modifiedDate;
    private final IlmPolicy policy;
    private final long version;
    public static final JsonpDeserializer<Lifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Lifecycle::setupLifecycleDeserializer);

    private Lifecycle(Builder builder) {
        this.modifiedDate = ApiTypeHelper.requireNonNull(builder.modifiedDate, this, "modifiedDate");
        this.policy = ApiTypeHelper.requireNonNull(builder.policy, this, "policy");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static Lifecycle of(Function<Builder, ObjectBuilder<Lifecycle>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modifiedDate() {
        return this.modifiedDate;
    }

    public final IlmPolicy policy() {
        return this.policy;
    }

    public final long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("modified_date");
        generator.write(this.modifiedDate);
        generator.writeKey("policy");
        this.policy.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupLifecycleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modifiedDate, JsonpDeserializer.stringDeserializer(), "modified_date");
        op.add(Builder::policy, IlmPolicy._DESERIALIZER, "policy");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Lifecycle> {
        private String modifiedDate;
        private IlmPolicy policy;
        private Long version;

        public final Builder modifiedDate(String value) {
            this.modifiedDate = value;
            return this;
        }

        public final Builder policy(IlmPolicy value) {
            this.policy = value;
            return this;
        }

        public final Builder policy(Function<IlmPolicy.Builder, ObjectBuilder<IlmPolicy>> fn) {
            return this.policy(fn.apply(new IlmPolicy.Builder()).build());
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        @Override
        public Lifecycle build() {
            this._checkSingleUse();
            return new Lifecycle(this);
        }
    }
}

