/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ilm.ExplainLifecycleResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ExplainLifecycleRequest
extends RequestBase {
    private final String index;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Boolean onlyErrors;
    @Nullable
    private final Boolean onlyManaged;
    @Nullable
    private final Time timeout;
    public static final Endpoint<ExplainLifecycleRequest, ExplainLifecycleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ExplainLifecycleRequest, ExplainLifecycleResponse>("es/ilm.explain_lifecycle", request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_ilm");
            buf.append("/explain");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.onlyErrors != null) {
            params.put("only_errors", String.valueOf(request.onlyErrors));
        }
        if (request.onlyManaged != null) {
            params.put("only_managed", String.valueOf(request.onlyManaged));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ExplainLifecycleResponse._DESERIALIZER);

    private ExplainLifecycleRequest(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.masterTimeout = builder.masterTimeout;
        this.onlyErrors = builder.onlyErrors;
        this.onlyManaged = builder.onlyManaged;
        this.timeout = builder.timeout;
    }

    public static ExplainLifecycleRequest of(Function<Builder, ObjectBuilder<ExplainLifecycleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Boolean onlyErrors() {
        return this.onlyErrors;
    }

    @Nullable
    public final Boolean onlyManaged() {
        return this.onlyManaged;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ExplainLifecycleRequest> {
        private String index;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Boolean onlyErrors;
        @Nullable
        private Boolean onlyManaged;
        @Nullable
        private Time timeout;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder onlyErrors(@Nullable Boolean value) {
            this.onlyErrors = value;
            return this;
        }

        public final Builder onlyManaged(@Nullable Boolean value) {
            this.onlyManaged = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public ExplainLifecycleRequest build() {
            this._checkSingleUse();
            return new ExplainLifecycleRequest(this);
        }
    }
}

