/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.elasticsearch.enrich.stats.CacheStats;
import co.elastic.clients.elasticsearch.enrich.stats.CoordinatorStats;
import co.elastic.clients.elasticsearch.enrich.stats.ExecutingPolicy;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EnrichStatsResponse
implements JsonpSerializable {
    private final List<CoordinatorStats> coordinatorStats;
    private final List<ExecutingPolicy> executingPolicies;
    private final List<CacheStats> cacheStats;
    public static final JsonpDeserializer<EnrichStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EnrichStatsResponse::setupEnrichStatsResponseDeserializer);

    private EnrichStatsResponse(Builder builder) {
        this.coordinatorStats = ApiTypeHelper.unmodifiableRequired(builder.coordinatorStats, (Object)this, "coordinatorStats");
        this.executingPolicies = ApiTypeHelper.unmodifiableRequired(builder.executingPolicies, (Object)this, "executingPolicies");
        this.cacheStats = ApiTypeHelper.unmodifiable(builder.cacheStats);
    }

    public static EnrichStatsResponse of(Function<Builder, ObjectBuilder<EnrichStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<CoordinatorStats> coordinatorStats() {
        return this.coordinatorStats;
    }

    public final List<ExecutingPolicy> executingPolicies() {
        return this.executingPolicies;
    }

    public final List<CacheStats> cacheStats() {
        return this.cacheStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.coordinatorStats)) {
            generator.writeKey("coordinator_stats");
            generator.writeStartArray();
            for (CoordinatorStats coordinatorStats : this.coordinatorStats) {
                coordinatorStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.executingPolicies)) {
            generator.writeKey("executing_policies");
            generator.writeStartArray();
            for (ExecutingPolicy executingPolicy : this.executingPolicies) {
                executingPolicy.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.cacheStats)) {
            generator.writeKey("cache_stats");
            generator.writeStartArray();
            for (CacheStats cacheStats : this.cacheStats) {
                cacheStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupEnrichStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::coordinatorStats, JsonpDeserializer.arrayDeserializer(CoordinatorStats._DESERIALIZER), "coordinator_stats");
        op.add(Builder::executingPolicies, JsonpDeserializer.arrayDeserializer(ExecutingPolicy._DESERIALIZER), "executing_policies");
        op.add(Builder::cacheStats, JsonpDeserializer.arrayDeserializer(CacheStats._DESERIALIZER), "cache_stats");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<EnrichStatsResponse> {
        private List<CoordinatorStats> coordinatorStats;
        private List<ExecutingPolicy> executingPolicies;
        @Nullable
        private List<CacheStats> cacheStats;

        public final Builder coordinatorStats(List<CoordinatorStats> list) {
            this.coordinatorStats = Builder._listAddAll(this.coordinatorStats, list);
            return this;
        }

        public final Builder coordinatorStats(CoordinatorStats value, CoordinatorStats ... values) {
            this.coordinatorStats = Builder._listAdd(this.coordinatorStats, value, values);
            return this;
        }

        public final Builder coordinatorStats(Function<CoordinatorStats.Builder, ObjectBuilder<CoordinatorStats>> fn) {
            return this.coordinatorStats(fn.apply(new CoordinatorStats.Builder()).build(), new CoordinatorStats[0]);
        }

        public final Builder executingPolicies(List<ExecutingPolicy> list) {
            this.executingPolicies = Builder._listAddAll(this.executingPolicies, list);
            return this;
        }

        public final Builder executingPolicies(ExecutingPolicy value, ExecutingPolicy ... values) {
            this.executingPolicies = Builder._listAdd(this.executingPolicies, value, values);
            return this;
        }

        public final Builder executingPolicies(Function<ExecutingPolicy.Builder, ObjectBuilder<ExecutingPolicy>> fn) {
            return this.executingPolicies(fn.apply(new ExecutingPolicy.Builder()).build(), new ExecutingPolicy[0]);
        }

        public final Builder cacheStats(List<CacheStats> list) {
            this.cacheStats = Builder._listAddAll(this.cacheStats, list);
            return this;
        }

        public final Builder cacheStats(CacheStats value, CacheStats ... values) {
            this.cacheStats = Builder._listAdd(this.cacheStats, value, values);
            return this;
        }

        public final Builder cacheStats(Function<CacheStats.Builder, ObjectBuilder<CacheStats>> fn) {
            return this.cacheStats(fn.apply(new CacheStats.Builder()).build(), new CacheStats[0]);
        }

        @Override
        public EnrichStatsResponse build() {
            this._checkSingleUse();
            return new EnrichStatsResponse(this);
        }
    }
}

