/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NestedIdentity
implements JsonpSerializable {
    private final String field;
    private final int offset;
    @Nullable
    private final NestedIdentity nested;
    public static final JsonpDeserializer<NestedIdentity> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedIdentity::setupNestedIdentityDeserializer);

    private NestedIdentity(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.offset = ApiTypeHelper.requireNonNull(builder.offset, this, "offset");
        this.nested = builder.nested;
    }

    public static NestedIdentity of(Function<Builder, ObjectBuilder<NestedIdentity>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final int offset() {
        return this.offset;
    }

    @Nullable
    public final NestedIdentity nested() {
        return this.nested;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("offset");
        generator.write(this.offset);
        if (this.nested != null) {
            generator.writeKey("_nested");
            this.nested.serialize(generator, mapper);
        }
    }

    protected static void setupNestedIdentityDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::offset, JsonpDeserializer.integerDeserializer(), "offset");
        op.add(Builder::nested, _DESERIALIZER, "_nested");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NestedIdentity> {
        private String field;
        private Integer offset;
        @Nullable
        private NestedIdentity nested;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder offset(int value) {
            this.offset = value;
            return this;
        }

        public final Builder nested(@Nullable NestedIdentity value) {
            this.nested = value;
            return this;
        }

        public final Builder nested(Function<Builder, ObjectBuilder<NestedIdentity>> fn) {
            return this.nested(fn.apply(new Builder()).build());
        }

        @Override
        public NestedIdentity build() {
            this._checkSingleUse();
            return new NestedIdentity(this);
        }
    }
}

