/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.msearch;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public class MultiSearchItem<TDocument>
extends SearchResponse<TDocument> {
    @Nullable
    private final Integer status;

    private MultiSearchItem(Builder<TDocument> builder) {
        super(builder);
        this.status = ((Builder)builder).status;
    }

    public static <TDocument> MultiSearchItem<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<MultiSearchItem<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer status() {
        return this.status;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status.intValue());
        }
    }

    public static <TDocument> JsonpDeserializer<MultiSearchItem<TDocument>> createMultiSearchItemDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> MultiSearchItem.setupMultiSearchItemDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupMultiSearchItemDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        SearchResponse.setupSearchResponseDeserializer(op, tDocumentDeserializer);
        op.add(Builder::status, JsonpDeserializer.integerDeserializer(), "status");
    }

    public static class Builder<TDocument>
    extends SearchResponse.AbstractBuilder<TDocument, Builder<TDocument>>
    implements ObjectBuilder<MultiSearchItem<TDocument>> {
        @Nullable
        private Integer status;

        public final Builder<TDocument> status(@Nullable Integer value) {
            this.status = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public MultiSearchItem<TDocument> build() {
            this._checkSingleUse();
            return new MultiSearchItem(this);
        }
    }
}

