/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.AllocationDecision;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.ClusterInfo;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.CurrentNode;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.Decision;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.NodeAllocationExplanation;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.UnassignedInformation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AllocationExplainResponse
implements JsonpSerializable {
    @Nullable
    private final String allocateExplanation;
    @Nullable
    private final String allocationDelay;
    @Nullable
    private final Long allocationDelayInMillis;
    @Nullable
    private final Decision canAllocate;
    @Nullable
    private final Decision canMoveToOtherNode;
    @Nullable
    private final Decision canRebalanceCluster;
    private final List<AllocationDecision> canRebalanceClusterDecisions;
    @Nullable
    private final Decision canRebalanceToOtherNode;
    private final List<AllocationDecision> canRemainDecisions;
    @Nullable
    private final Decision canRemainOnCurrentNode;
    @Nullable
    private final ClusterInfo clusterInfo;
    @Nullable
    private final String configuredDelay;
    @Nullable
    private final Long configuredDelayInMillis;
    @Nullable
    private final CurrentNode currentNode;
    private final String currentState;
    private final String index;
    @Nullable
    private final String moveExplanation;
    private final List<NodeAllocationExplanation> nodeAllocationDecisions;
    private final boolean primary;
    @Nullable
    private final String rebalanceExplanation;
    @Nullable
    private final String remainingDelay;
    @Nullable
    private final Long remainingDelayInMillis;
    private final int shard;
    @Nullable
    private final UnassignedInformation unassignedInfo;
    @Nullable
    private final String note;
    public static final JsonpDeserializer<AllocationExplainResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationExplainResponse::setupAllocationExplainResponseDeserializer);

    private AllocationExplainResponse(Builder builder) {
        this.allocateExplanation = builder.allocateExplanation;
        this.allocationDelay = builder.allocationDelay;
        this.allocationDelayInMillis = builder.allocationDelayInMillis;
        this.canAllocate = builder.canAllocate;
        this.canMoveToOtherNode = builder.canMoveToOtherNode;
        this.canRebalanceCluster = builder.canRebalanceCluster;
        this.canRebalanceClusterDecisions = ApiTypeHelper.unmodifiable(builder.canRebalanceClusterDecisions);
        this.canRebalanceToOtherNode = builder.canRebalanceToOtherNode;
        this.canRemainDecisions = ApiTypeHelper.unmodifiable(builder.canRemainDecisions);
        this.canRemainOnCurrentNode = builder.canRemainOnCurrentNode;
        this.clusterInfo = builder.clusterInfo;
        this.configuredDelay = builder.configuredDelay;
        this.configuredDelayInMillis = builder.configuredDelayInMillis;
        this.currentNode = builder.currentNode;
        this.currentState = ApiTypeHelper.requireNonNull(builder.currentState, this, "currentState");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.moveExplanation = builder.moveExplanation;
        this.nodeAllocationDecisions = ApiTypeHelper.unmodifiable(builder.nodeAllocationDecisions);
        this.primary = ApiTypeHelper.requireNonNull(builder.primary, this, "primary");
        this.rebalanceExplanation = builder.rebalanceExplanation;
        this.remainingDelay = builder.remainingDelay;
        this.remainingDelayInMillis = builder.remainingDelayInMillis;
        this.shard = ApiTypeHelper.requireNonNull(builder.shard, this, "shard");
        this.unassignedInfo = builder.unassignedInfo;
        this.note = builder.note;
    }

    public static AllocationExplainResponse of(Function<Builder, ObjectBuilder<AllocationExplainResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String allocateExplanation() {
        return this.allocateExplanation;
    }

    @Nullable
    public final String allocationDelay() {
        return this.allocationDelay;
    }

    @Nullable
    public final Long allocationDelayInMillis() {
        return this.allocationDelayInMillis;
    }

    @Nullable
    public final Decision canAllocate() {
        return this.canAllocate;
    }

    @Nullable
    public final Decision canMoveToOtherNode() {
        return this.canMoveToOtherNode;
    }

    @Nullable
    public final Decision canRebalanceCluster() {
        return this.canRebalanceCluster;
    }

    public final List<AllocationDecision> canRebalanceClusterDecisions() {
        return this.canRebalanceClusterDecisions;
    }

    @Nullable
    public final Decision canRebalanceToOtherNode() {
        return this.canRebalanceToOtherNode;
    }

    public final List<AllocationDecision> canRemainDecisions() {
        return this.canRemainDecisions;
    }

    @Nullable
    public final Decision canRemainOnCurrentNode() {
        return this.canRemainOnCurrentNode;
    }

    @Nullable
    public final ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    @Nullable
    public final String configuredDelay() {
        return this.configuredDelay;
    }

    @Nullable
    public final Long configuredDelayInMillis() {
        return this.configuredDelayInMillis;
    }

    @Nullable
    public final CurrentNode currentNode() {
        return this.currentNode;
    }

    public final String currentState() {
        return this.currentState;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String moveExplanation() {
        return this.moveExplanation;
    }

    public final List<NodeAllocationExplanation> nodeAllocationDecisions() {
        return this.nodeAllocationDecisions;
    }

    public final boolean primary() {
        return this.primary;
    }

    @Nullable
    public final String rebalanceExplanation() {
        return this.rebalanceExplanation;
    }

    @Nullable
    public final String remainingDelay() {
        return this.remainingDelay;
    }

    @Nullable
    public final Long remainingDelayInMillis() {
        return this.remainingDelayInMillis;
    }

    public final int shard() {
        return this.shard;
    }

    @Nullable
    public final UnassignedInformation unassignedInfo() {
        return this.unassignedInfo;
    }

    @Nullable
    public final String note() {
        return this.note;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allocateExplanation != null) {
            generator.writeKey("allocate_explanation");
            generator.write(this.allocateExplanation);
        }
        if (this.allocationDelay != null) {
            generator.writeKey("allocation_delay");
            generator.write(this.allocationDelay);
        }
        if (this.allocationDelayInMillis != null) {
            generator.writeKey("allocation_delay_in_millis");
            generator.write(this.allocationDelayInMillis.longValue());
        }
        if (this.canAllocate != null) {
            generator.writeKey("can_allocate");
            this.canAllocate.serialize(generator, mapper);
        }
        if (this.canMoveToOtherNode != null) {
            generator.writeKey("can_move_to_other_node");
            this.canMoveToOtherNode.serialize(generator, mapper);
        }
        if (this.canRebalanceCluster != null) {
            generator.writeKey("can_rebalance_cluster");
            this.canRebalanceCluster.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.canRebalanceClusterDecisions)) {
            generator.writeKey("can_rebalance_cluster_decisions");
            generator.writeStartArray();
            for (AllocationDecision allocationDecision : this.canRebalanceClusterDecisions) {
                allocationDecision.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.canRebalanceToOtherNode != null) {
            generator.writeKey("can_rebalance_to_other_node");
            this.canRebalanceToOtherNode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.canRemainDecisions)) {
            generator.writeKey("can_remain_decisions");
            generator.writeStartArray();
            for (AllocationDecision allocationDecision : this.canRemainDecisions) {
                allocationDecision.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.canRemainOnCurrentNode != null) {
            generator.writeKey("can_remain_on_current_node");
            this.canRemainOnCurrentNode.serialize(generator, mapper);
        }
        if (this.clusterInfo != null) {
            generator.writeKey("cluster_info");
            this.clusterInfo.serialize(generator, mapper);
        }
        if (this.configuredDelay != null) {
            generator.writeKey("configured_delay");
            generator.write(this.configuredDelay);
        }
        if (this.configuredDelayInMillis != null) {
            generator.writeKey("configured_delay_in_millis");
            generator.write(this.configuredDelayInMillis.longValue());
        }
        if (this.currentNode != null) {
            generator.writeKey("current_node");
            this.currentNode.serialize(generator, mapper);
        }
        generator.writeKey("current_state");
        generator.write(this.currentState);
        generator.writeKey("index");
        generator.write(this.index);
        if (this.moveExplanation != null) {
            generator.writeKey("move_explanation");
            generator.write(this.moveExplanation);
        }
        if (ApiTypeHelper.isDefined(this.nodeAllocationDecisions)) {
            generator.writeKey("node_allocation_decisions");
            generator.writeStartArray();
            for (NodeAllocationExplanation nodeAllocationExplanation : this.nodeAllocationDecisions) {
                nodeAllocationExplanation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("primary");
        generator.write(this.primary);
        if (this.rebalanceExplanation != null) {
            generator.writeKey("rebalance_explanation");
            generator.write(this.rebalanceExplanation);
        }
        if (this.remainingDelay != null) {
            generator.writeKey("remaining_delay");
            generator.write(this.remainingDelay);
        }
        if (this.remainingDelayInMillis != null) {
            generator.writeKey("remaining_delay_in_millis");
            generator.write(this.remainingDelayInMillis.longValue());
        }
        generator.writeKey("shard");
        generator.write(this.shard);
        if (this.unassignedInfo != null) {
            generator.writeKey("unassigned_info");
            this.unassignedInfo.serialize(generator, mapper);
        }
        if (this.note != null) {
            generator.writeKey("note");
            generator.write(this.note);
        }
    }

    protected static void setupAllocationExplainResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocateExplanation, JsonpDeserializer.stringDeserializer(), "allocate_explanation");
        op.add(Builder::allocationDelay, JsonpDeserializer.stringDeserializer(), "allocation_delay");
        op.add(Builder::allocationDelayInMillis, JsonpDeserializer.longDeserializer(), "allocation_delay_in_millis");
        op.add(Builder::canAllocate, Decision._DESERIALIZER, "can_allocate");
        op.add(Builder::canMoveToOtherNode, Decision._DESERIALIZER, "can_move_to_other_node");
        op.add(Builder::canRebalanceCluster, Decision._DESERIALIZER, "can_rebalance_cluster");
        op.add(Builder::canRebalanceClusterDecisions, JsonpDeserializer.arrayDeserializer(AllocationDecision._DESERIALIZER), "can_rebalance_cluster_decisions");
        op.add(Builder::canRebalanceToOtherNode, Decision._DESERIALIZER, "can_rebalance_to_other_node");
        op.add(Builder::canRemainDecisions, JsonpDeserializer.arrayDeserializer(AllocationDecision._DESERIALIZER), "can_remain_decisions");
        op.add(Builder::canRemainOnCurrentNode, Decision._DESERIALIZER, "can_remain_on_current_node");
        op.add(Builder::clusterInfo, ClusterInfo._DESERIALIZER, "cluster_info");
        op.add(Builder::configuredDelay, JsonpDeserializer.stringDeserializer(), "configured_delay");
        op.add(Builder::configuredDelayInMillis, JsonpDeserializer.longDeserializer(), "configured_delay_in_millis");
        op.add(Builder::currentNode, CurrentNode._DESERIALIZER, "current_node");
        op.add(Builder::currentState, JsonpDeserializer.stringDeserializer(), "current_state");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::moveExplanation, JsonpDeserializer.stringDeserializer(), "move_explanation");
        op.add(Builder::nodeAllocationDecisions, JsonpDeserializer.arrayDeserializer(NodeAllocationExplanation._DESERIALIZER), "node_allocation_decisions");
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary");
        op.add(Builder::rebalanceExplanation, JsonpDeserializer.stringDeserializer(), "rebalance_explanation");
        op.add(Builder::remainingDelay, JsonpDeserializer.stringDeserializer(), "remaining_delay");
        op.add(Builder::remainingDelayInMillis, JsonpDeserializer.longDeserializer(), "remaining_delay_in_millis");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
        op.add(Builder::unassignedInfo, UnassignedInformation._DESERIALIZER, "unassigned_info");
        op.add(Builder::note, JsonpDeserializer.stringDeserializer(), "note");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<AllocationExplainResponse> {
        @Nullable
        private String allocateExplanation;
        @Nullable
        private String allocationDelay;
        @Nullable
        private Long allocationDelayInMillis;
        @Nullable
        private Decision canAllocate;
        @Nullable
        private Decision canMoveToOtherNode;
        @Nullable
        private Decision canRebalanceCluster;
        @Nullable
        private List<AllocationDecision> canRebalanceClusterDecisions;
        @Nullable
        private Decision canRebalanceToOtherNode;
        @Nullable
        private List<AllocationDecision> canRemainDecisions;
        @Nullable
        private Decision canRemainOnCurrentNode;
        @Nullable
        private ClusterInfo clusterInfo;
        @Nullable
        private String configuredDelay;
        @Nullable
        private Long configuredDelayInMillis;
        @Nullable
        private CurrentNode currentNode;
        private String currentState;
        private String index;
        @Nullable
        private String moveExplanation;
        @Nullable
        private List<NodeAllocationExplanation> nodeAllocationDecisions;
        private Boolean primary;
        @Nullable
        private String rebalanceExplanation;
        @Nullable
        private String remainingDelay;
        @Nullable
        private Long remainingDelayInMillis;
        private Integer shard;
        @Nullable
        private UnassignedInformation unassignedInfo;
        @Nullable
        private String note;

        public final Builder allocateExplanation(@Nullable String value) {
            this.allocateExplanation = value;
            return this;
        }

        public final Builder allocationDelay(@Nullable String value) {
            this.allocationDelay = value;
            return this;
        }

        public final Builder allocationDelayInMillis(@Nullable Long value) {
            this.allocationDelayInMillis = value;
            return this;
        }

        public final Builder canAllocate(@Nullable Decision value) {
            this.canAllocate = value;
            return this;
        }

        public final Builder canMoveToOtherNode(@Nullable Decision value) {
            this.canMoveToOtherNode = value;
            return this;
        }

        public final Builder canRebalanceCluster(@Nullable Decision value) {
            this.canRebalanceCluster = value;
            return this;
        }

        public final Builder canRebalanceClusterDecisions(List<AllocationDecision> list) {
            this.canRebalanceClusterDecisions = Builder._listAddAll(this.canRebalanceClusterDecisions, list);
            return this;
        }

        public final Builder canRebalanceClusterDecisions(AllocationDecision value, AllocationDecision ... values) {
            this.canRebalanceClusterDecisions = Builder._listAdd(this.canRebalanceClusterDecisions, value, values);
            return this;
        }

        public final Builder canRebalanceClusterDecisions(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.canRebalanceClusterDecisions(fn.apply(new AllocationDecision.Builder()).build(), new AllocationDecision[0]);
        }

        public final Builder canRebalanceToOtherNode(@Nullable Decision value) {
            this.canRebalanceToOtherNode = value;
            return this;
        }

        public final Builder canRemainDecisions(List<AllocationDecision> list) {
            this.canRemainDecisions = Builder._listAddAll(this.canRemainDecisions, list);
            return this;
        }

        public final Builder canRemainDecisions(AllocationDecision value, AllocationDecision ... values) {
            this.canRemainDecisions = Builder._listAdd(this.canRemainDecisions, value, values);
            return this;
        }

        public final Builder canRemainDecisions(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.canRemainDecisions(fn.apply(new AllocationDecision.Builder()).build(), new AllocationDecision[0]);
        }

        public final Builder canRemainOnCurrentNode(@Nullable Decision value) {
            this.canRemainOnCurrentNode = value;
            return this;
        }

        public final Builder clusterInfo(@Nullable ClusterInfo value) {
            this.clusterInfo = value;
            return this;
        }

        public final Builder clusterInfo(Function<ClusterInfo.Builder, ObjectBuilder<ClusterInfo>> fn) {
            return this.clusterInfo(fn.apply(new ClusterInfo.Builder()).build());
        }

        public final Builder configuredDelay(@Nullable String value) {
            this.configuredDelay = value;
            return this;
        }

        public final Builder configuredDelayInMillis(@Nullable Long value) {
            this.configuredDelayInMillis = value;
            return this;
        }

        public final Builder currentNode(@Nullable CurrentNode value) {
            this.currentNode = value;
            return this;
        }

        public final Builder currentNode(Function<CurrentNode.Builder, ObjectBuilder<CurrentNode>> fn) {
            return this.currentNode(fn.apply(new CurrentNode.Builder()).build());
        }

        public final Builder currentState(String value) {
            this.currentState = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder moveExplanation(@Nullable String value) {
            this.moveExplanation = value;
            return this;
        }

        public final Builder nodeAllocationDecisions(List<NodeAllocationExplanation> list) {
            this.nodeAllocationDecisions = Builder._listAddAll(this.nodeAllocationDecisions, list);
            return this;
        }

        public final Builder nodeAllocationDecisions(NodeAllocationExplanation value, NodeAllocationExplanation ... values) {
            this.nodeAllocationDecisions = Builder._listAdd(this.nodeAllocationDecisions, value, values);
            return this;
        }

        public final Builder nodeAllocationDecisions(Function<NodeAllocationExplanation.Builder, ObjectBuilder<NodeAllocationExplanation>> fn) {
            return this.nodeAllocationDecisions(fn.apply(new NodeAllocationExplanation.Builder()).build(), new NodeAllocationExplanation[0]);
        }

        public final Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public final Builder rebalanceExplanation(@Nullable String value) {
            this.rebalanceExplanation = value;
            return this;
        }

        public final Builder remainingDelay(@Nullable String value) {
            this.remainingDelay = value;
            return this;
        }

        public final Builder remainingDelayInMillis(@Nullable Long value) {
            this.remainingDelayInMillis = value;
            return this;
        }

        public final Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public final Builder unassignedInfo(@Nullable UnassignedInformation value) {
            this.unassignedInfo = value;
            return this;
        }

        public final Builder unassignedInfo(Function<UnassignedInformation.Builder, ObjectBuilder<UnassignedInformation>> fn) {
            return this.unassignedInfo(fn.apply(new UnassignedInformation.Builder()).build());
        }

        public final Builder note(@Nullable String value) {
            this.note = value;
            return this;
        }

        @Override
        public AllocationExplainResponse build() {
            this._checkSingleUse();
            return new AllocationExplainResponse(this);
        }
    }
}

