/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.TransformsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class TransformsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final String transformId;
    public static final Endpoint<TransformsRequest, TransformsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TransformsRequest, TransformsResponse>("es/cat.transforms", request -> "GET", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (request.transformId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/transforms");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/transforms");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, TransformsResponse._DESERIALIZER);

    private TransformsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.size = builder.size;
        this.transformId = builder.transformId;
    }

    public static TransformsRequest of(Function<Builder, ObjectBuilder<TransformsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final String transformId() {
        return this.transformId;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TransformsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private String transformId;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder transformId(@Nullable String value) {
            this.transformId = value;
            return this;
        }

        @Override
        public TransformsRequest build() {
            this._checkSingleUse();
            return new TransformsRequest(this);
        }
    }
}

