/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlDataFrameAnalyticsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class MlDataFrameAnalyticsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final String id;
    public static final Endpoint<MlDataFrameAnalyticsRequest, MlDataFrameAnalyticsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MlDataFrameAnalyticsRequest, MlDataFrameAnalyticsResponse>("es/cat.ml_data_frame_analytics", request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlDataFrameAnalyticsResponse._DESERIALIZER);

    private MlDataFrameAnalyticsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.bytes = builder.bytes;
        this.id = builder.id;
    }

    public static MlDataFrameAnalyticsRequest of(Function<Builder, ObjectBuilder<MlDataFrameAnalyticsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MlDataFrameAnalyticsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Bytes bytes;
        @Nullable
        private String id;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Override
        public MlDataFrameAnalyticsRequest build() {
            this._checkSingleUse();
            return new MlDataFrameAnalyticsRequest(this);
        }
    }
}

