/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOptionsVariant;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScoreSort
implements SortOptionsVariant,
JsonpSerializable {
    @Nullable
    private final SortOrder order;
    public static final JsonpDeserializer<ScoreSort> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScoreSort::setupScoreSortDeserializer);

    private ScoreSort(Builder builder) {
        this.order = builder.order;
    }

    public static ScoreSort of(Function<Builder, ObjectBuilder<ScoreSort>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SortOptions.Kind _sortOptionsKind() {
        return SortOptions.Kind.Doc;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
    }

    protected static void setupScoreSortDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::order, SortOrder._DESERIALIZER, "order");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ScoreSort> {
        @Nullable
        private SortOrder order;

        public final Builder order(@Nullable SortOrder value) {
            this.order = value;
            return this;
        }

        @Override
        public ScoreSort build() {
            this._checkSingleUse();
            return new ScoreSort(this);
        }
    }
}

