/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.LayerVersionsListItem;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse;

public class ListLayerVersionsPublisher
implements SdkPublisher<ListLayerVersionsResponse> {
    private final LambdaAsyncClient client;
    private final ListLayerVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLayerVersionsPublisher(LambdaAsyncClient client, ListLayerVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLayerVersionsPublisher(LambdaAsyncClient client, ListLayerVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLayerVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLayerVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LayerVersionsListItem> layerVersions() {
        Function<ListLayerVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.layerVersions() != null) {
                return response.layerVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLayerVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLayerVersionsResponseFetcher
    implements AsyncPageFetcher<ListLayerVersionsResponse> {
        private ListLayerVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLayerVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListLayerVersionsResponse> nextPage(ListLayerVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListLayerVersionsPublisher.this.client.listLayerVersions(ListLayerVersionsPublisher.this.firstRequest);
            }
            return ListLayerVersionsPublisher.this.client.listLayerVersions((ListLayerVersionsRequest)((Object)ListLayerVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

