/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TracingMode {
    ACTIVE("Active"),
    PASS_THROUGH("PassThrough"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TracingMode> VALUE_MAP;
    private final String value;

    private TracingMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TracingMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TracingMode> knownValues() {
        EnumSet<TracingMode> knownValues = EnumSet.allOf(TracingMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TracingMode.class, TracingMode::toString);
    }
}

