/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.common.utils.RetryUtil;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessor;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessorConfig;
import org.opensearch.dataprepper.plugins.ml_inference.processor.common.AbstractBatchJobCreator;
import org.opensearch.dataprepper.plugins.ml_inference.processor.exception.MLBatchJobException;
import org.slf4j.Logger;

public class BedrockBatchJobCreator
extends AbstractBatchJobCreator {
    private final AwsCredentialsSupplier awsCredentialsSupplier;
    private static final String BEDROCK_PAYLOAD_TEMPLATE = "{\"parameters\": {\"inputDataConfig\": {\"s3InputDataConfig\": {\"s3Uri\": \"s3://\"}},\"jobName\": \"\", \"outputDataConfig\": {\"s3OutputDataConfig\": {\"s3Uri\": \"s3://\"}}}}";

    public BedrockBatchJobCreator(MLProcessorConfig mlProcessorConfig, AwsCredentialsSupplier awsCredentialsSupplier, PluginMetrics pluginMetrics) {
        super(mlProcessorConfig, awsCredentialsSupplier, pluginMetrics);
        this.awsCredentialsSupplier = awsCredentialsSupplier;
    }

    @Override
    public void createMLBatchJob(List<Record<Event>> inputRecords, List<Record<Event>> resultRecords) {
        ArrayList failedRecords = new ArrayList();
        inputRecords.stream().forEach(record -> {
            try {
                String s3Uri = this.generateS3Uri((Record<Event>)record);
                String payload = this.createPayloadBedrock(s3Uri, this.mlProcessorConfig);
                boolean success = RetryUtil.retryWithBackoff(() -> this.mlCommonRequester.sendRequestToMLCommons(payload), (Logger)MLProcessor.LOG);
                if (success) {
                    MLProcessor.LOG.info("Successfully created Bedrock batch job for the S3Uri: {}", (Object)s3Uri);
                    resultRecords.add((Record<Event>)record);
                    this.incrementSuccessCounter();
                } else {
                    this.handleFailure((Record<Event>)record, resultRecords, failedRecords);
                    MLProcessor.LOG.error("Failed to create Bedrock batch job after multiple retries for: " + s3Uri);
                }
            }
            catch (IllegalArgumentException e) {
                MLProcessor.LOG.error(DataPrepperMarkers.NOISY, "Invalid arguments for BedRock batch job. Error: {}", (Object)e.getMessage());
                this.handleFailure((Record<Event>)record, resultRecords, failedRecords);
            }
            catch (Exception e) {
                MLProcessor.LOG.error(DataPrepperMarkers.NOISY, "Unexpected Error occurred while creating a batch job through BedRock. Error: {}", (Object)e.getMessage(), (Object)e);
                this.handleFailure((Record<Event>)record, resultRecords, failedRecords);
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                MLProcessor.LOG.debug("Interrupted during sleep: " + e.getMessage());
            }
        });
        if (!failedRecords.isEmpty()) {
            throw new MLBatchJobException("Failed to process the following records: " + String.valueOf(failedRecords), new Throwable("Batch job creation failed due to one or more failed records"));
        }
    }

    private void handleFailure(Record<Event> record, List<Record<Event>> resultRecords, List<Record<Event>> failedRecords) {
        resultRecords.addAll(this.addFailureTags(Collections.singletonList(record)));
        this.incrementFailureCounter();
        failedRecords.add(record);
    }

    private String generateS3Uri(Record<Event> record) {
        String bucket = Optional.ofNullable(((Event)record.getData()).getJsonNode().path("bucket").asText(null)).orElseThrow(() -> new IllegalArgumentException("Missing 'bucket' in record."));
        EventKey inputKey = this.mlProcessorConfig.getInputKey();
        String key = Optional.ofNullable(inputKey == null ? ((Event)record.getData()).getJsonNode().path("key").asText(null) : (String)((Event)record.getData()).get(inputKey, String.class)).orElseThrow(() -> new IllegalArgumentException("Missing 'S3 Key' in record."));
        return "s3://" + bucket + "/" + key;
    }

    private String createPayloadBedrock(String S3Uri, MLProcessorConfig mlProcessorConfig) {
        if (S3Uri == null || S3Uri.isEmpty()) {
            throw new IllegalArgumentException("Invalid S3Uri: S3Uri is either null or empty. Please ensure the correct input S3 uris are provided");
        }
        String jobName = this.generateJobName();
        try {
            JsonNode rootNode = OBJECT_MAPPER.readTree(BEDROCK_PAYLOAD_TEMPLATE);
            ((ObjectNode)rootNode.at("/parameters/inputDataConfig/s3InputDataConfig")).put("s3Uri", S3Uri);
            ((ObjectNode)rootNode.at("/parameters")).put("jobName", jobName);
            ((ObjectNode)rootNode.at("/parameters/outputDataConfig/s3OutputDataConfig")).put("s3Uri", mlProcessorConfig.getOutputPath());
            return OBJECT_MAPPER.writeValueAsString((Object)rootNode);
        }
        catch (Exception e) {
            MLProcessor.LOG.error("Failed to create BedRock batch job payload with input {}.", (Object)S3Uri, (Object)e);
            throw new RuntimeException("Failed to create payload for BedRock batch job", e);
        }
    }
}

