/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.util.StringUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingResultBuilder;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GlobPathMapping
extends AbstractPathMapping {
    private final String prefix;
    private final String glob;
    private final int numGroupsToSkip;
    private final Pattern pattern;
    private final int numParams;
    private final Set<String> paramNames;
    private final String pathPattern;
    private final String strVal;
    private final List<String> paths;

    GlobPathMapping(String glob, int numGroupsToSkip) {
        this("", glob, numGroupsToSkip);
    }

    private GlobPathMapping(String prefix, String glob, int numGroupsToSkip) {
        String aGlob;
        PatternAndParamCount patternAndParamCount = GlobPathMapping.globToRegex(glob, numGroupsToSkip);
        this.prefix = prefix;
        this.glob = glob;
        this.numGroupsToSkip = numGroupsToSkip;
        this.pattern = patternAndParamCount.pattern;
        this.numParams = patternAndParamCount.numParams;
        ImmutableSet.Builder paramNames = ImmutableSet.builder();
        for (int i = 0; i < this.numParams; ++i) {
            paramNames.add(StringUtil.toString(i));
        }
        this.paramNames = paramNames.build();
        this.strVal = "glob:" + glob;
        this.pathPattern = aGlob = glob.startsWith("/") ? glob : "/**/" + glob;
        this.paths = ImmutableList.of(this.pattern.pattern(), aGlob);
    }

    @Override
    PathMapping doWithPrefix(String prefix) {
        String prefixGlob;
        int numGroupsToSkip = this.numGroupsToSkip;
        if (this.glob.startsWith("/")) {
            prefixGlob = ArmeriaHttpUtil.concatPaths(prefix, this.glob);
        } else {
            prefixGlob = ArmeriaHttpUtil.concatPaths(prefix + "**/", this.glob);
            ++numGroupsToSkip;
        }
        return new GlobPathMapping(prefix, prefixGlob, numGroupsToSkip);
    }

    @Override
    @Nullable
    RoutingResultBuilder doApply(RoutingContext routingCtx) {
        Matcher m = this.pattern.matcher(routingCtx.path());
        if (!m.matches()) {
            return null;
        }
        RoutingResultBuilder builder = RoutingResult.builderWithExpectedNumParams(this.numParams).path(GlobPathMapping.mappedPath(this.prefix, routingCtx.path())).query(routingCtx.query());
        for (int i = 1; i <= this.numParams; ++i) {
            String value = MoreObjects.firstNonNull(m.group(i), "");
            builder.rawParam(StringUtil.toString(i - 1), value);
        }
        return builder;
    }

    @Override
    public Set<String> paramNames() {
        return this.paramNames;
    }

    @Override
    public String patternString() {
        return this.pathPattern;
    }

    @Override
    public RoutePathType pathType() {
        return RoutePathType.REGEX;
    }

    @Override
    public List<String> paths() {
        return this.paths;
    }

    public int hashCode() {
        return this.glob.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof GlobPathMapping && (this == obj || this.glob.equals(((GlobPathMapping)obj).glob));
    }

    @Override
    public String toString() {
        return this.strVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    static PatternAndParamCount globToRegex(String glob, int numGroupsToSkip) {
        int numGroups = 0;
        if (glob.charAt(0) != '/') {
            glob = "/**/" + glob;
            ++numGroupsToSkip;
        }
        int pathPatternLen = glob.length();
        StringBuilder buf = new StringBuilder(pathPatternLen).append("^/");
        int asterisks = 0;
        int beforeAsterisk = 47;
        block11: for (int i = 1; i < pathPatternLen; ++i) {
            char c = glob.charAt(i);
            if (c == '*') {
                if (++asterisks <= 2) continue;
                throw new IllegalArgumentException("contains a path pattern with invalid wildcard characters: " + glob + " (only * and ** are allowed)");
            }
            switch (asterisks) {
                case 1: {
                    if (numGroupsToSkip <= 0) {
                        buf.append('(');
                        ++numGroups;
                    }
                    if (beforeAsterisk == 47 && c == '/') {
                        buf.append("[^/]+");
                    } else {
                        buf.append("[^/]*");
                    }
                    if (numGroupsToSkip <= 0) {
                        buf.append(')');
                        break;
                    }
                    --numGroupsToSkip;
                    break;
                }
                case 2: {
                    if (beforeAsterisk == 47 && c == '/') {
                        buf.append("(?:");
                        if (numGroupsToSkip <= 0) {
                            buf.append('(');
                            ++numGroups;
                        }
                        buf.append(".+");
                        if (numGroupsToSkip <= 0) {
                            buf.append(')');
                        } else {
                            --numGroupsToSkip;
                        }
                        buf.append("/)?");
                        asterisks = 0;
                        continue block11;
                    }
                    if (numGroupsToSkip <= 0) {
                        buf.append('(');
                        ++numGroups;
                    }
                    buf.append(".*");
                    if (numGroupsToSkip <= 0) {
                        buf.append(')');
                        break;
                    }
                    --numGroupsToSkip;
                }
            }
            asterisks = 0;
            beforeAsterisk = c;
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    buf.append('\\');
                    buf.append(c);
                    continue block11;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        switch (asterisks) {
            case 1: {
                if (numGroupsToSkip <= 0) {
                    buf.append('(');
                    ++numGroups;
                }
                if (beforeAsterisk == 47) {
                    buf.append("[^/]+");
                } else {
                    buf.append("[^/]*");
                }
                if (numGroupsToSkip > 0) return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
                buf.append(')');
                return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
            }
            case 2: {
                if (numGroupsToSkip <= 0) {
                    buf.append('(');
                    ++numGroups;
                }
                buf.append(".*");
                if (numGroupsToSkip > 0) return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
                buf.append(')');
                return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
            }
        }
        return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
    }

    private static final class PatternAndParamCount {
        final Pattern pattern;
        final int numParams;

        PatternAndParamCount(Pattern pattern, int numParams) {
            this.pattern = pattern;
            this.numParams = numParams;
        }
    }
}

