/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.util.BitSetUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.net.HostAndPort;
import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.BitSet;
import java.util.Objects;

public final class SchemeAndAuthority {
    private static final BitSet RESERVED_CHARS = BitSetUtil.toBitSet("/?#");
    @Nullable
    private final String scheme;
    private final String authority;
    private final String host;
    private final int port;

    public static SchemeAndAuthority of(@Nullable String scheme, String authority) {
        Objects.requireNonNull(authority, "authority");
        if (scheme != null) {
            scheme = ArmeriaHttpUtil.schemeValidateAndNormalize(scheme);
        }
        if (authority.startsWith("unix%3A") || authority.startsWith("unix%3a")) {
            return new SchemeAndAuthority(scheme, authority, authority, -1);
        }
        String authorityWithoutUserInfo = SchemeAndAuthority.removeUserInfo(authority);
        for (int i = 0; i < authorityWithoutUserInfo.length(); ++i) {
            char c = authorityWithoutUserInfo.charAt(i);
            if (c >= '\u0080' || !RESERVED_CHARS.get(c)) continue;
            throw new IllegalArgumentException("The authority contains reserved character: " + authority + " (" + c + ')');
        }
        try {
            boolean isIpv6;
            URI uri = new URI(null, authorityWithoutUserInfo, null, null, null);
            String rawAuthority = uri.getRawAuthority();
            if (Strings.isNullOrEmpty(rawAuthority)) {
                throw new IllegalArgumentException("Invalid authority: " + authority);
            }
            boolean bl = isIpv6 = (rawAuthority = IDN.toASCII(rawAuthority, 1)).charAt(0) == '[';
            if (isIpv6) {
                rawAuthority = SchemeAndAuthority.removeIpv6ScopeId(rawAuthority);
            }
            HostAndPort hostAndPort = HostAndPort.fromString(rawAuthority);
            String host = hostAndPort.getHost();
            if (isIpv6) {
                host = '[' + host + ']';
            }
            int port = hostAndPort.getPortOrDefault(-1);
            return new SchemeAndAuthority(scheme, rawAuthority, host, port);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String removeIpv6ScopeId(String ipV6Authority) {
        int percentPos = ipV6Authority.indexOf(37);
        if (percentPos == -1) {
            return ipV6Authority;
        }
        int endBracket = ipV6Authority.indexOf(93);
        assert (endBracket > 0) : "endBracket: " + endBracket + " (expected: > 0)";
        return ipV6Authority.substring(0, percentPos) + ipV6Authority.substring(endBracket);
    }

    private static String removeUserInfo(String authority) {
        int indexOfDelimiter = authority.lastIndexOf(64);
        if (indexOfDelimiter == -1) {
            return authority;
        }
        return authority.substring(indexOfDelimiter + 1);
    }

    private SchemeAndAuthority(@Nullable String scheme, String authority, String host, int port) {
        this.scheme = scheme;
        this.authority = authority;
        this.host = host;
        this.port = port;
    }

    @Nullable
    public String scheme() {
        return this.scheme;
    }

    public String authority() {
        return this.authority;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }
}

