/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.proxy;

import com.linecorp.armeria.client.proxy.ConnectProxyConfig;
import com.linecorp.armeria.client.proxy.DirectProxyConfig;
import com.linecorp.armeria.client.proxy.HAProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyType;
import com.linecorp.armeria.client.proxy.Socks4ProxyConfig;
import com.linecorp.armeria.client.proxy.Socks5ProxyConfig;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.Objects;

public abstract class ProxyConfig {
    public static Socks4ProxyConfig socks4(InetSocketAddress proxyAddress) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        return new Socks4ProxyConfig(proxyAddress, null);
    }

    public static Socks4ProxyConfig socks4(InetSocketAddress proxyAddress, String username) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        return new Socks4ProxyConfig(proxyAddress, Objects.requireNonNull(username, "username"));
    }

    public static Socks5ProxyConfig socks5(InetSocketAddress proxyAddress) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        return new Socks5ProxyConfig(proxyAddress, null, null);
    }

    public static Socks5ProxyConfig socks5(InetSocketAddress proxyAddress, String username, String password) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        return new Socks5ProxyConfig(proxyAddress, Objects.requireNonNull(username, "username"), Objects.requireNonNull(password, "password"));
    }

    public static ConnectProxyConfig connect(InetSocketAddress proxyAddress) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        return new ConnectProxyConfig(proxyAddress, null, null, HttpHeaders.of(), false);
    }

    public static ConnectProxyConfig connect(InetSocketAddress proxyAddress, boolean useTls) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        return new ConnectProxyConfig(proxyAddress, null, null, HttpHeaders.of(), useTls);
    }

    public static ConnectProxyConfig connect(InetSocketAddress proxyAddress, String username, String password, boolean useTls) {
        return ProxyConfig.connect(proxyAddress, username, password, HttpHeaders.of(), useTls);
    }

    @UnstableApi
    public static ConnectProxyConfig connect(InetSocketAddress proxyAddress, HttpHeaders headers, boolean useTls) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        return new ConnectProxyConfig(proxyAddress, null, null, headers, useTls);
    }

    @UnstableApi
    public static ConnectProxyConfig connect(InetSocketAddress proxyAddress, String username, String password, HttpHeaders headers, boolean useTls) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(password, "password");
        Objects.requireNonNull(headers, "headers");
        return new ConnectProxyConfig(proxyAddress, username, password, headers, useTls);
    }

    public static HAProxyConfig haproxy(InetSocketAddress proxyAddress, InetSocketAddress sourceAddress) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        Objects.requireNonNull(sourceAddress, "sourceAddress");
        Preconditions.checkArgument(!sourceAddress.isUnresolved(), "sourceAddress must be resolved");
        return new HAProxyConfig(proxyAddress, sourceAddress);
    }

    public static ProxyConfig haproxy(InetSocketAddress proxyAddress) {
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        return new HAProxyConfig(proxyAddress);
    }

    public static ProxyConfig direct() {
        return DirectProxyConfig.DIRECT_PROXY_CONFIG;
    }

    ProxyConfig() {
    }

    public abstract ProxyType proxyType();

    @Nullable
    public abstract InetSocketAddress proxyAddress();

    public abstract ProxyConfig withProxyAddress(InetSocketAddress var1);

    @Nullable
    static String maskPassword(@Nullable String username, @Nullable String password) {
        return username != null ? "****" : null;
    }
}

