/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.anomalydetector.modes;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.anomalydetector.AnomalyDetectorMode;
import org.opensearch.dataprepper.plugins.processor.anomalydetector.modes.RandomCutForestModeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="random_cut_forest", pluginType=AnomalyDetectorMode.class, pluginConfigurationType=RandomCutForestModeConfig.class)
public class RandomCutForestMode
implements AnomalyDetectorMode {
    private static final int NUMBER_OF_TREES = 50;
    private static final double ANOMALY_RATE = 0.01;
    private static final double INITIAL_ACCEPT_FRACTION = 0.125;
    private static final double LOWER_THRESHOLD = 1.1;
    private static final double HORIZON_VALUE = 0.75;
    private ThresholdedRandomCutForest forest;
    private int baseDimensions;
    private int sampleSize;
    private int outputAfter;
    private int shingleSize;
    private double timeDecay;
    private List<String> keys;
    private final Lock processLock;
    private static final Logger LOG = LoggerFactory.getLogger(RandomCutForestMode.class);

    @DataPrepperPluginConstructor
    public RandomCutForestMode(RandomCutForestModeConfig randomCutForestModeConfig) {
        this.sampleSize = randomCutForestModeConfig.getSampleSize();
        this.shingleSize = randomCutForestModeConfig.getShingleSize();
        this.outputAfter = randomCutForestModeConfig.getOutputAfter();
        this.timeDecay = randomCutForestModeConfig.getTimeDecay();
        this.processLock = new ReentrantLock();
    }

    @Override
    public void initialize(List<String> keys, boolean verbose) {
        this.keys = keys;
        this.baseDimensions = keys.size();
        Precision precision = Precision.FLOAT_32;
        int dimensions = this.baseDimensions * this.shingleSize;
        TransformMethod transformMethod = TransformMethod.NORMALIZE;
        this.forest = ThresholdedRandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(50).shingleSize(this.shingleSize).sampleSize(this.sampleSize).internalShinglingEnabled(true).precision(precision).anomalyRate(0.01).forestMode(ForestMode.STANDARD).transformMethod(transformMethod).outputAfter(this.outputAfter).timeDecay(this.timeDecay / (double)this.sampleSize).initialAcceptFraction(0.125).autoAdjust(!verbose).build();
        this.forest.setLowerThreshold(1.1);
        this.forest.setHorizon(0.75);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Record<Event>> handleEvents(Collection<Record<Event>> records) {
        int timeStamp = (int)Instant.now().getEpochSecond();
        ArrayList<Record<Event>> recordsOut = new ArrayList<Record<Event>>();
        for (Record<Event> record : records) {
            int i;
            Event event = (Event)record.getData();
            boolean notFound = false;
            double[] points = new double[this.keys.size()];
            int index = 0;
            for (String key : this.keys) {
                Number value = (Number)event.get(key, Number.class);
                if (value == null) {
                    notFound = true;
                    break;
                }
                points[index] = value instanceof Long ? (double)value.longValue() : (value instanceof Integer ? (double)value.intValue() : (value instanceof Short ? (double)value.shortValue() : (value instanceof Byte ? (double)value.byteValue() : (value instanceof Float ? (double)value.floatValue() : value.doubleValue()))));
                ++index;
            }
            if (notFound) continue;
            AnomalyDescriptor result = null;
            this.processLock.lock();
            try {
                result = this.forest.process(points, (long)timeStamp);
            }
            catch (Exception e) {
                LOG.debug("Error while processing the event in RCF: ", (Throwable)e);
            }
            finally {
                this.processLock.unlock();
            }
            if (result == null || result.getAnomalyGrade() == 0.0 || !result.isExpectedValuesPresent()) continue;
            double[] deviations = new double[this.keys.size()];
            if (result.getRelativeIndex() != 0 && result.isStartOfAnomaly()) {
                for (i = 0; i < this.keys.size(); ++i) {
                    deviations[i] = result.getPastValues()[i];
                }
            } else {
                for (i = 0; i < this.keys.size(); ++i) {
                    deviations[i] = result.getCurrentInput()[i] - result.getExpectedValuesList()[0][i];
                }
            }
            event.put("deviation_from_expected", (Object)deviations);
            event.put("grade", (Object)result.getAnomalyGrade());
            recordsOut.add(record);
        }
        return recordsOut;
    }
}

