/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion.jsr310;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.dataformat.ion.IonGenerator;
import com.fasterxml.jackson.dataformat.ion.jsr310.TimestampUtils;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.BiFunction;
import java.util.function.Function;

public class IonTimestampInstantSerializer<T extends Temporal>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    public static final IonTimestampInstantSerializer<Instant> INSTANT = new IonTimestampInstantSerializer<Instant>(Instant.class, Function.identity(), instant -> ZoneOffset.UTC, (instant, zoneId) -> instant.atZone((ZoneId)zoneId).getOffset());
    public static final IonTimestampInstantSerializer<OffsetDateTime> OFFSET_DATE_TIME = new IonTimestampInstantSerializer<OffsetDateTime>(OffsetDateTime.class, OffsetDateTime::toInstant, OffsetDateTime::getOffset, (offsetDateTime, zoneId) -> offsetDateTime.atZoneSameInstant((ZoneId)zoneId).getOffset());
    public static final IonTimestampInstantSerializer<ZonedDateTime> ZONED_DATE_TIME = new IonTimestampInstantSerializer<ZonedDateTime>(ZonedDateTime.class, ChronoZonedDateTime::toInstant, ZonedDateTime::getOffset, (zonedDateTime, zoneId) -> zonedDateTime.withZoneSameInstant((ZoneId)zoneId).getOffset());
    private final Function<T, Instant> getInstant;
    private final Function<T, ZoneOffset> getOffset;
    private final BiFunction<T, ZoneId, ZoneOffset> getOffsetAtZoneId;
    private final ZoneId zoneIdOverride;
    private final Boolean writeDateTimestampsAsNanosOverride;

    protected IonTimestampInstantSerializer(Class<T> t, Function<T, Instant> getInstant, Function<T, ZoneOffset> getOffset, BiFunction<T, ZoneId, ZoneOffset> getOffsetAtZoneId) {
        super(t);
        this.getInstant = getInstant;
        this.getOffset = getOffset;
        this.getOffsetAtZoneId = getOffsetAtZoneId;
        this.zoneIdOverride = null;
        this.writeDateTimestampsAsNanosOverride = null;
    }

    protected IonTimestampInstantSerializer(IonTimestampInstantSerializer<T> base, ZoneId zoneIdOverride, Boolean writeDateTimestampsAsNanosOverride) {
        super(base.handledType());
        this.getInstant = base.getInstant;
        this.getOffset = base.getOffset;
        this.getOffsetAtZoneId = base.getOffsetAtZoneId;
        this.zoneIdOverride = zoneIdOverride;
        this.writeDateTimestampsAsNanosOverride = writeDateTimestampsAsNanosOverride;
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Instant instant = this.getInstant.apply(value);
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            if (this.shouldWriteTimestampsAsNanos(provider)) {
                gen.writeNumber(TimestampUtils.getFractionalSeconds(instant));
            } else {
                gen.writeNumber(instant.toEpochMilli());
            }
        } else {
            ZoneOffset offset = this.getOffset(value);
            ((IonGenerator)gen).writeValue(TimestampUtils.toTimestamp(instant, offset));
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(prov, property, this.handledType());
        if (format != null) {
            return new IonTimestampInstantSerializer<T>(this, format.getTimeZone() == null ? null : format.getTimeZone().toZoneId(), format.getFeature(JsonFormat.Feature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS));
        }
        return this;
    }

    private boolean shouldWriteTimestampsAsNanos(SerializerProvider provider) {
        if (Boolean.FALSE.equals(this.writeDateTimestampsAsNanosOverride)) {
            return false;
        }
        return provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS) || Boolean.TRUE.equals(this.writeDateTimestampsAsNanosOverride);
    }

    private ZoneOffset getOffset(T value) {
        if (null != this.zoneIdOverride) {
            return this.getOffsetAtZoneId.apply(value, this.zoneIdOverride);
        }
        return this.getOffset.apply(value);
    }
}

