/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.amazon.ion.Timestamp;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import java.io.IOException;
import java.util.Date;

public class IonTimestampDeserializers {

    public static class IonTimestampSQLDateDeserializer
    extends DateDeserializers.SqlDateDeserializer {
        private static final long serialVersionUID = 1L;

        public java.sql.Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object embedded;
            if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT) && (embedded = p.getEmbeddedObject()) instanceof Timestamp) {
                return new java.sql.Date(((Timestamp)embedded).dateValue().getTime());
            }
            return super.deserialize(p, ctxt);
        }
    }

    public static class IonTimestampJavaDateDeserializer
    extends DateDeserializers.DateDeserializer {
        private static final long serialVersionUID = 1L;

        public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object embedded;
            if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT) && (embedded = p.getEmbeddedObject()) instanceof Timestamp) {
                return ((Timestamp)embedded).dateValue();
            }
            return super.deserialize(p, ctxt);
        }
    }
}

