/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.system.IonSystemBuilder;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.UTF8Writer;
import com.fasterxml.jackson.core.util.TextBuffer;
import com.fasterxml.jackson.dataformat.ion.IonFactoryBuilder;
import com.fasterxml.jackson.dataformat.ion.IonGenerator;
import com.fasterxml.jackson.dataformat.ion.IonParser;
import com.fasterxml.jackson.dataformat.ion.PackageVersion;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IonFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_ION = "AmazonIon";
    protected final IonSystem _system;
    protected boolean _cfgCreateBinaryWriters = false;
    protected static final int DEFAULT_ION_PARSER_FEATURE_FLAGS = IonParser.Feature.collectDefaults();
    protected static final int DEFAULT_ION_GENERATOR_FEATURE_FLAGS = IonGenerator.Feature.collectDefaults();
    protected int _ionParserFeatures = DEFAULT_ION_PARSER_FEATURE_FLAGS;
    protected int _ionGeneratorFeatures = DEFAULT_ION_GENERATOR_FEATURE_FLAGS;

    public IonFactory() {
        this((ObjectCodec)null);
    }

    public IonFactory(ObjectCodec mapper) {
        this(mapper, IonSystemBuilder.standard().build());
    }

    public IonFactory(ObjectCodec mapper, IonSystem system) {
        super(mapper);
        this._system = system;
    }

    protected IonFactory(IonFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
        this._system = src._system;
        this._cfgCreateBinaryWriters = src._cfgCreateBinaryWriters;
    }

    protected IonFactory(IonFactoryBuilder b) {
        super((TSFBuilder)b, false);
        this._cfgCreateBinaryWriters = b.willCreateBinaryWriters();
        this._system = b.ionSystem();
        this._ionParserFeatures = b.formatParserFeaturesMask();
        this._ionGeneratorFeatures = b.formatGeneratorFeaturesMask();
    }

    public IonFactoryBuilder rebuild() {
        return new IonFactoryBuilder(this);
    }

    public static IonFactory forBinaryWriters() {
        return new IonFactoryBuilder(true).build();
    }

    public static IonFactory forTextualWriters() {
        return new IonFactoryBuilder(false).build();
    }

    public static IonFactoryBuilder builderForBinaryWriters() {
        return new IonFactoryBuilder(true);
    }

    public static IonFactoryBuilder builderForTextualWriters() {
        return new IonFactoryBuilder(false);
    }

    public IonFactory copy() {
        this._checkInvalidCopy(IonFactory.class);
        return new IonFactory(this, null);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public String getFormatName() {
        return FORMAT_NAME_ION;
    }

    public void setCreateBinaryWriters(boolean b) {
        this._cfgCreateBinaryWriters = b;
    }

    public boolean createBinaryWriters() {
        return this._cfgCreateBinaryWriters;
    }

    public boolean canHandleBinaryNatively() {
        return this._cfgCreateBinaryWriters;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public final IonFactory configure(IonParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public IonFactory enable(IonParser.Feature f) {
        this._ionParserFeatures |= f.getMask();
        return this;
    }

    public IonFactory disable(IonParser.Feature f) {
        this._ionParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(IonParser.Feature f) {
        return (this._ionParserFeatures & f.getMask()) != 0;
    }

    public int getFormatParserFeatures() {
        return this._ionParserFeatures;
    }

    public final IonFactory configure(IonGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public IonFactory enable(IonGenerator.Feature f) {
        this._ionGeneratorFeatures |= f.getMask();
        return this;
    }

    public IonFactory disable(IonGenerator.Feature f) {
        this._ionGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(IonGenerator.Feature f) {
        return (this._ionGeneratorFeatures & f.getMask()) != 0;
    }

    public int getFormatGeneratorFeatures() {
        return this._ionGeneratorFeatures;
    }

    public IonParser createParser(IonReader in) {
        return new IonParser(in, this._system, this._createContext(this._createContentReference(in), false), this.getCodec(), this._ionParserFeatures);
    }

    public IonParser createParser(IonValue value) {
        IonReader in = value.getSystem().newReader(value);
        return new IonParser(in, this._system, this._createContext(this._createContentReference(in), true), this.getCodec(), this._ionParserFeatures);
    }

    public JsonGenerator createGenerator(IonWriter out) {
        return this._createGenerator(out, false, this._createContext(this._createContentReference(out), false), (Closeable)out);
    }

    public IonSystem getIonSystem() {
        return this._system;
    }

    @Deprecated
    public IonParser createJsonParser(IonReader in) {
        return this.createParser(in);
    }

    @Deprecated
    public IonParser createJsonParser(IonValue value) {
        return this.createParser(value);
    }

    @Deprecated
    public JsonGenerator createJsonGenerator(IonWriter out) {
        return this.createGenerator(out);
    }

    protected JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        IonReader ion = this._system.newReader(in);
        return new IonParser(ion, this._system, this._createContext(this._createContentReference(ion), true), this.getCodec(), this._ionParserFeatures);
    }

    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        IonReader ion = this._system.newReader(r);
        return new IonParser(ion, this._system, this._createContext(this._createContentReference(ion), true), this.getCodec(), this._ionParserFeatures);
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return this._createParser(new CharArrayReader(data, offset, len), ctxt);
    }

    protected JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        IonReader ion = this._system.newReader(data, offset, len);
        return new IonParser(ion, this._system, this._createContext(this._createContentReference(ion), true), this.getCodec(), this._ionParserFeatures);
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this._createGenerator(out, enc, false);
    }

    public JsonGenerator createGenerator(Writer out) throws IOException {
        if (this.createBinaryWriters()) {
            throw new IOException("Can only create binary Ion writers that output to OutputStream, not Writer");
        }
        return this._createGenerator(this._system.newTextWriter((Appendable)out), true, this._createContext(this._createContentReference(out), false), out);
    }

    public JsonGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        return this._createGenerator(new FileOutputStream(f), enc, true);
    }

    @Deprecated
    protected String _readAll(Reader r, IOContext ctxt) throws IOException {
        TextBuffer tb = ctxt.constructTextBuffer();
        char[] buf = tb.emptyAndGetCurrentSegment();
        int offset = 0;
        while (true) {
            if (offset < buf.length) {
                int count = r.read(buf, offset, buf.length - offset);
                if (count < 0) break;
                offset += count;
                continue;
            }
            buf = tb.finishCurrentSegment();
            offset = 0;
        }
        tb.setCurrentLength(offset);
        String result = tb.contentsAsString();
        tb.releaseBuffers();
        return result;
    }

    protected IonGenerator _createGenerator(OutputStream out, JsonEncoding enc, boolean isManaged) throws IOException {
        OutputStream dst;
        IonWriter ion;
        IOContext ctxt = this._createContext(this._createContentReference(out), isManaged);
        if (this.createBinaryWriters()) {
            ctxt.setEncoding(enc);
            ion = this._system.newBinaryWriter(out, new SymbolTable[0]);
            dst = out;
        } else {
            if (enc != JsonEncoding.UTF8) {
                throw new IOException("Ion only supports UTF-8 encoding, can not use " + enc);
            }
            ctxt.setEncoding(enc);
            UTF8Writer w = new UTF8Writer(ctxt, out);
            ion = this._system.newTextWriter((Appendable)w);
            dst = w;
        }
        return this._createGenerator(ion, true, ctxt, dst);
    }

    protected IonGenerator _createGenerator(IonWriter ion, boolean ionWriterIsManaged, IOContext ctxt, Closeable dst) {
        return new IonGenerator(this._generatorFeatures, this._ionGeneratorFeatures, this._objectCodec, ion, ionWriterIsManaged, ctxt, dst);
    }
}

