/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListUsageProfilesRequest;
import software.amazon.awssdk.services.glue.model.ListUsageProfilesResponse;
import software.amazon.awssdk.services.glue.model.UsageProfileDefinition;

public class ListUsageProfilesIterable
implements SdkIterable<ListUsageProfilesResponse> {
    private final GlueClient client;
    private final ListUsageProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUsageProfilesIterable(GlueClient client, ListUsageProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUsageProfilesResponseFetcher();
    }

    public Iterator<ListUsageProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UsageProfileDefinition> profiles() {
        Function<ListUsageProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.profiles() != null) {
                return response.profiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUsageProfilesResponseFetcher
    implements SyncPageFetcher<ListUsageProfilesResponse> {
        private ListUsageProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListUsageProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUsageProfilesResponse nextPage(ListUsageProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListUsageProfilesIterable.this.client.listUsageProfiles(ListUsageProfilesIterable.this.firstRequest);
            }
            return ListUsageProfilesIterable.this.client.listUsageProfiles((ListUsageProfilesRequest)((Object)ListUsageProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

