/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3EncryptionMode {
    DISABLED("DISABLED"),
    SSE_KMS("SSE-KMS"),
    SSE_S3("SSE-S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3EncryptionMode> VALUE_MAP;
    private final String value;

    private S3EncryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3EncryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3EncryptionMode> knownValues() {
        EnumSet<S3EncryptionMode> knownValues = EnumSet.allOf(S3EncryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3EncryptionMode.class, S3EncryptionMode::toString);
    }
}

