/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.KeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartitionIndex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartitionIndex> {
    private static final SdkField<List<String>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Keys").getter(PartitionIndex.getter(PartitionIndex::keys)).setter(PartitionIndex.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(PartitionIndex.getter(PartitionIndex::indexName)).setter(PartitionIndex.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYS_FIELD, INDEX_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PartitionIndex.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> keys;
    private final String indexName;

    private PartitionIndex(BuilderImpl builder) {
        this.keys = builder.keys;
        this.indexName = builder.indexName;
    }

    public final boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public final List<String> keys() {
        return this.keys;
    }

    public final String indexName() {
        return this.indexName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionIndex)) {
            return false;
        }
        PartitionIndex other = (PartitionIndex)obj;
        return this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys()) && Objects.equals(this.indexName(), other.indexName());
    }

    public final String toString() {
        return ToString.builder((String)"PartitionIndex").add("Keys", this.hasKeys() ? this.keys() : null).add("IndexName", (Object)this.indexName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Keys", KEYS_FIELD);
        map.put("IndexName", INDEX_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartitionIndex, T> g) {
        return obj -> g.apply((PartitionIndex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();
        private String indexName;

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionIndex model) {
            this.keys(model.keys);
            this.indexName(model.indexName);
        }

        public final Collection<String> getKeys() {
            if (this.keys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = KeyListCopier.copy(keys);
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = KeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public PartitionIndex build() {
            return new PartitionIndex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartitionIndex> {
        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);

        public Builder indexName(String var1);
    }
}

