/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobMode {
    SCRIPT("SCRIPT"),
    VISUAL("VISUAL"),
    NOTEBOOK("NOTEBOOK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobMode> VALUE_MAP;
    private final String value;

    private JobMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobMode> knownValues() {
        EnumSet<JobMode> knownValues = EnumSet.allOf(JobMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobMode.class, JobMode::toString);
    }
}

