/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.source;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.kafka.configuration.AuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.EncryptionConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaConsumerConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicConsumerConfig;
import org.opensearch.dataprepper.plugins.kafka.source.SourceTopicConfig;

public class KafkaSourceConfig
implements KafkaConsumerConfig {
    @JsonProperty(value="bootstrap_servers")
    private List<String> bootStrapServers;
    @JsonProperty(value="topics")
    @NotNull
    @Size(min=1, max=10, message="The number of Topics should be between 1 and 10")
    private @NotNull @Size(min=1, max=10, message="The number of Topics should be between 1 and 10") List<SourceTopicConfig> topics;
    @JsonProperty(value="schema")
    @Valid
    private SchemaConfig schemaConfig;
    @Valid
    @JsonProperty(value="authentication")
    private AuthConfig authConfig;
    @JsonProperty(value="encryption")
    private EncryptionConfig encryptionConfig;
    @JsonProperty(value="aws")
    @Valid
    private AwsConfig awsConfig;
    @JsonProperty(value="acknowledgments")
    private Boolean acknowledgementsEnabled = false;
    @JsonProperty(value="client_dns_lookup")
    private String clientDnsLookup;

    @Override
    public String getClientDnsLookup() {
        return this.clientDnsLookup;
    }

    @Override
    public boolean getAcknowledgementsEnabled() {
        return this.acknowledgementsEnabled;
    }

    public List<? extends TopicConsumerConfig> getTopics() {
        return this.topics;
    }

    public void setTopics(List<SourceTopicConfig> topics) {
        this.topics = topics;
    }

    public List<String> getBootstrapServers() {
        if (Objects.nonNull(this.bootStrapServers)) {
            return this.bootStrapServers;
        }
        return null;
    }

    public void setBootStrapServers(List<String> bootStrapServers) {
        this.bootStrapServers = bootStrapServers;
    }

    @Override
    public SchemaConfig getSchemaConfig() {
        return this.schemaConfig;
    }

    public void setSchemaConfig(SchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
    }

    @Override
    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public void setAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    @Override
    public EncryptionConfig getEncryptionConfig() {
        if (Objects.isNull(this.encryptionConfig)) {
            return new EncryptionConfig();
        }
        return this.encryptionConfig;
    }

    public void setEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.encryptionConfig = encryptionConfig;
    }

    public EncryptionConfig getEncryptionConfigRaw() {
        return this.encryptionConfig;
    }

    @Override
    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public void setAwsConfig(AwsConfig awsConfig) {
        this.awsConfig = awsConfig;
    }
}

