/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.sink;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.AbstractSink;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.plugins.kafka.common.serialization.CommonSerializationFactory;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicProducerConfig;
import org.opensearch.dataprepper.plugins.kafka.producer.KafkaCustomProducer;
import org.opensearch.dataprepper.plugins.kafka.producer.KafkaCustomProducerFactory;
import org.opensearch.dataprepper.plugins.kafka.producer.ProducerWorker;
import org.opensearch.dataprepper.plugins.kafka.service.SchemaService;
import org.opensearch.dataprepper.plugins.kafka.service.TopicService;
import org.opensearch.dataprepper.plugins.kafka.service.TopicServiceFactory;
import org.opensearch.dataprepper.plugins.kafka.sink.DLQSink;
import org.opensearch.dataprepper.plugins.kafka.sink.KafkaSinkConfig;
import org.opensearch.dataprepper.plugins.kafka.util.RestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="kafka", pluginType=Sink.class, pluginConfigurationType=KafkaSinkConfig.class)
public class KafkaSink
extends AbstractSink<Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSink.class);
    private final KafkaSinkConfig kafkaSinkConfig;
    private final KafkaCustomProducerFactory kafkaCustomProducerFactory;
    private final TopicServiceFactory topicServiceFactory;
    private volatile boolean sinkInitialized;
    private static final Integer totalWorkers = 1;
    private ProducerWorker producerWorker;
    private ExecutorService executorService;
    private final PluginFactory pluginFactory;
    private final PluginSetting pluginSetting;
    private final PluginMetrics pluginMetrics;
    private final ExpressionEvaluator expressionEvaluator;
    private final Lock reentrantLock;
    private final SinkContext sinkContext;

    @DataPrepperPluginConstructor
    public KafkaSink(PluginSetting pluginSetting, KafkaSinkConfig kafkaSinkConfig, PluginFactory pluginFactory, PluginMetrics pluginMetrics, ExpressionEvaluator expressionEvaluator, SinkContext sinkContext, AwsCredentialsSupplier awsCredentialsSupplier) {
        super(pluginSetting);
        this.pluginSetting = pluginSetting;
        this.pluginMetrics = pluginMetrics;
        this.kafkaSinkConfig = kafkaSinkConfig;
        this.pluginFactory = pluginFactory;
        this.expressionEvaluator = expressionEvaluator;
        this.reentrantLock = new ReentrantLock();
        this.sinkContext = sinkContext;
        CommonSerializationFactory serializationFactory = new CommonSerializationFactory();
        this.topicServiceFactory = new TopicServiceFactory();
        this.kafkaCustomProducerFactory = new KafkaCustomProducerFactory(serializationFactory, awsCredentialsSupplier, this.topicServiceFactory);
    }

    public void doInitialize() {
        try {
            this.doInitializeInternal();
        }
        catch (InvalidPluginConfigurationException e) {
            LOG.error("Invalid plugin configuration, Hence failed to initialize kafka-sink plugin.");
            this.shutdown();
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to initialize kafka-sink plugin.");
            this.shutdown();
            throw e;
        }
    }

    private void doInitializeInternal() {
        this.executorService = Executors.newFixedThreadPool(totalWorkers);
        this.sinkInitialized = Boolean.TRUE;
    }

    public void doOutput(Collection<Record<Event>> records) {
        this.reentrantLock.lock();
        if (records.isEmpty()) {
            return;
        }
        try {
            this.prepareTopicAndSchema();
            KafkaCustomProducer producer = this.createProducer();
            records.forEach(record -> {
                this.producerWorker = new ProducerWorker(producer, (Record<Event>)record);
                this.executorService.submit(this.producerWorker);
            });
        }
        catch (Exception e) {
            LOG.error("Failed to setup the Kafka sink Plugin.", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        this.reentrantLock.unlock();
    }

    private void prepareTopicAndSchema() {
        this.checkTopicCreationCriteriaAndCreateTopic();
        SchemaConfig schemaConfig = this.kafkaSinkConfig.getSchemaConfig();
        if (schemaConfig != null && schemaConfig.isCreate().booleanValue()) {
            RestUtils restUtils = new RestUtils(schemaConfig);
            String topic = this.kafkaSinkConfig.getTopic().getName();
            SchemaService schemaService = new SchemaService.SchemaServiceBuilder().getRegisterationAndCompatibilityService(topic, this.kafkaSinkConfig.getSerdeFormat(), restUtils, schemaConfig).build();
            schemaService.registerSchema(topic);
        }
    }

    private void checkTopicCreationCriteriaAndCreateTopic() {
        TopicProducerConfig topic = this.kafkaSinkConfig.getTopic();
        if (topic.isCreateTopic()) {
            TopicService topicService = this.topicServiceFactory.createTopicService(this.kafkaSinkConfig);
            topicService.createTopic(this.kafkaSinkConfig.getTopic().getName(), topic.getNumberOfPartitions(), topic.getReplicationFactor(), null);
            topicService.closeAdminClient();
        }
    }

    private KafkaCustomProducer createProducer() {
        DLQSink dlqSink = new DLQSink(this.pluginFactory, this.kafkaSinkConfig, this.pluginSetting);
        return this.kafkaCustomProducerFactory.createProducer(this.kafkaSinkConfig, this.expressionEvaluator, this.sinkContext, this.pluginMetrics, dlqSink, true);
    }

    public void shutdown() {
        block3: {
            try {
                if (!this.executorService.awaitTermination(this.calculateLongestThreadWaitingTime(), TimeUnit.MILLISECONDS)) {
                    this.executorService.shutdownNow();
                }
                LOG.info("Sink threads are waiting for shutting down...");
            }
            catch (InterruptedException e) {
                if (!(e.getCause() instanceof InterruptedException)) break block3;
                LOG.error("Interrupted during sink shutdown, exiting uncleanly...");
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        super.shutdown();
        LOG.info("Producer shutdown successfully...");
    }

    private long calculateLongestThreadWaitingTime() {
        return this.kafkaSinkConfig.getThreadWaitTime();
    }

    public boolean isReady() {
        return this.sinkInitialized;
    }
}

