/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.sink;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.plugins.dlq.DlqProvider;
import org.opensearch.dataprepper.plugins.dlq.DlqWriter;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaProducerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLQSink {
    private static final Logger LOG = LoggerFactory.getLogger(DLQSink.class);
    private final DlqProvider dlqProvider;
    private final PluginSetting pluginSetting;

    public DLQSink(PluginFactory pluginFactory, KafkaProducerConfig kafkaProducerConfig, PluginSetting pluginSetting) {
        this.pluginSetting = pluginSetting;
        this.dlqProvider = this.getDlqProvider(pluginFactory, kafkaProducerConfig);
    }

    public void perform(Object failedData, Throwable e) {
        DlqWriter dlqWriter = this.getDlqWriter();
        if (dlqWriter == null) {
            LOG.error("Call to perform() when not DLQ is configured. This is possibly a programming error.");
            return;
        }
        DlqObject dlqObject = DlqObject.builder().withPluginId(UUID.randomUUID().toString()).withPluginName(this.pluginSetting.getName()).withPipelineName(this.pluginSetting.getPipelineName()).withFailedData(failedData).build();
        this.logFailureForDlqObjects(dlqWriter, List.of(dlqObject));
    }

    private DlqWriter getDlqWriter() {
        if (this.dlqProvider == null) {
            return null;
        }
        Optional potentialDlq = this.dlqProvider.getDlqWriter(new StringJoiner(".").add(this.pluginSetting.getPipelineName()).add(this.pluginSetting.getName()).toString());
        DlqWriter dlqWriter = potentialDlq.isPresent() ? (DlqWriter)potentialDlq.get() : null;
        return dlqWriter;
    }

    private DlqProvider getDlqProvider(PluginFactory pluginFactory, KafkaProducerConfig kafkaProducerConfig) {
        kafkaProducerConfig.setDlqConfig(this.pluginSetting);
        Optional<PluginModel> dlq = kafkaProducerConfig.getDlq();
        if (dlq.isPresent()) {
            PluginModel dlqPluginModel = dlq.get();
            PluginSetting dlqPluginSetting = new PluginSetting(dlqPluginModel.getPluginName(), dlqPluginModel.getPluginSettings());
            dlqPluginSetting.setPipelineName(this.pluginSetting.getPipelineName());
            DlqProvider dlqProvider = (DlqProvider)pluginFactory.loadPlugin(DlqProvider.class, dlqPluginSetting, new Object[0]);
            return dlqProvider;
        }
        return null;
    }

    private void logFailureForDlqObjects(DlqWriter dlqWriter, List<DlqObject> dlqObjects) {
        try {
            dlqWriter.write(dlqObjects, this.pluginSetting.getPipelineName(), this.pluginSetting.getName());
            dlqObjects.forEach(dlqObject -> dlqObject.releaseEventHandle(true));
        }
        catch (IOException e) {
            dlqObjects.forEach(dlqObject -> {
                LOG.error(DataPrepperMarkers.SENSITIVE, "DLQ failure for Document[{}]", dlqObject.getFailedData(), (Object)e);
                dlqObject.releaseEventHandle(false);
            });
        }
    }
}

