/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.extension;

import org.opensearch.dataprepper.model.annotations.DataPrepperExtensionPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.plugin.ExtensionPlugin;
import org.opensearch.dataprepper.model.plugin.ExtensionPoints;
import org.opensearch.dataprepper.model.plugin.ExtensionProvider;
import org.opensearch.dataprepper.plugins.kafka.extension.DefaultKafkaClusterConfigSupplier;
import org.opensearch.dataprepper.plugins.kafka.extension.KafkaClusterConfig;
import org.opensearch.dataprepper.plugins.kafka.extension.KafkaClusterConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperExtensionPlugin(modelType=KafkaClusterConfig.class, rootKeyJsonPath="/kafka_cluster_config")
public class KafkaClusterConfigExtension
implements ExtensionPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaClusterConfigExtension.class);
    private DefaultKafkaClusterConfigSupplier defaultKafkaClusterConfigSupplier;

    @DataPrepperPluginConstructor
    public KafkaClusterConfigExtension(KafkaClusterConfig kafkaClusterConfig) {
        this.defaultKafkaClusterConfigSupplier = new DefaultKafkaClusterConfigSupplier(kafkaClusterConfig);
    }

    public void apply(ExtensionPoints extensionPoints) {
        LOG.info("Applying Kafka Cluster Config Extension.");
        extensionPoints.addExtensionProvider((ExtensionProvider)new KafkaClusterConfigProvider(this.defaultKafkaClusterConfigSupplier));
    }
}

