/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.common.serialization;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

class EncryptionContext {
    private static final String AES_ALGORITHM = "AES";
    private final Key encryptionKey;

    EncryptionContext(Key encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    static EncryptionContext fromEncryptionKey(byte[] encryptionKey) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(encryptionKey, AES_ALGORITHM);
        return new EncryptionContext(secretKeySpec);
    }

    Cipher createEncryptionCipher() throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return this.createCipher(1);
    }

    Cipher createDecryptionCipher() throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return this.createCipher(2);
    }

    Key getEncryptionKey() {
        return this.encryptionKey;
    }

    private Cipher createCipher(int encryptMode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(encryptMode, this.encryptionKey);
        return cipher;
    }
}

