/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import io.confluent.kafka.schemaregistry.json.jackson.JSONObjectDeserializer;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONArrayDeserializer
extends StdDeserializer<JSONArray> {
    private static final long serialVersionUID = 1L;
    public static final JSONArrayDeserializer instance = new JSONArrayDeserializer();

    public JSONArrayDeserializer() {
        super(JSONArray.class);
    }

    public JSONArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t;
        if (!p.isExpectedStartArrayToken()) {
            JsonToken t2 = p.currentToken();
            return (JSONArray)ctxt.handleUnexpectedToken(this.handledType(), t2, p, "Unexpected token (%s), expected START_ARRAY for %s value", new Object[]{t2, ClassUtil.nameOf((Class)this.handledType())});
        }
        JSONArray array = new JSONArray();
        block11: while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            switch (t) {
                case START_ARRAY: {
                    array.put((Object)this.deserialize(p, ctxt));
                    continue block11;
                }
                case START_OBJECT: {
                    array.put((Object)JSONObjectDeserializer.instance.deserialize(p, ctxt));
                    continue block11;
                }
                case VALUE_STRING: {
                    array.put((Object)p.getText());
                    continue block11;
                }
                case VALUE_NULL: {
                    array.put(JSONObject.NULL);
                    continue block11;
                }
                case VALUE_TRUE: {
                    array.put((Object)Boolean.TRUE);
                    continue block11;
                }
                case VALUE_FALSE: {
                    array.put((Object)Boolean.FALSE);
                    continue block11;
                }
                case VALUE_NUMBER_INT: {
                    Number num = p.getNumberValue();
                    if (num instanceof Byte || num instanceof Short) {
                        num = num.intValue();
                    }
                    array.put((Object)num);
                    continue block11;
                }
                case VALUE_NUMBER_FLOAT: {
                    array.put((Object)p.getNumberValue());
                    continue block11;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object o = p.getEmbeddedObject();
                    if (o instanceof byte[]) {
                        o = p.getText();
                    }
                    array.put(o);
                    continue block11;
                }
            }
            return (JSONArray)ctxt.handleUnexpectedToken(this.handledType(), p);
        }
        return array;
    }
}

