/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetHealthReason {
    UNREACHABLE("UNREACHABLE"),
    CONNECTION_FAILED("CONNECTION_FAILED"),
    AUTH_FAILURE("AUTH_FAILURE"),
    PENDING_PROXY_CAPACITY("PENDING_PROXY_CAPACITY"),
    INVALID_REPLICATION_STATE("INVALID_REPLICATION_STATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetHealthReason> VALUE_MAP;
    private final String value;

    private TargetHealthReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetHealthReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetHealthReason> knownValues() {
        EnumSet<TargetHealthReason> knownValues = EnumSet.allOf(TargetHealthReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetHealthReason.class, TargetHealthReason::toString);
    }
}

