/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyDbClusterSnapshotRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CopyDbClusterSnapshotRequest> {
    private static final SdkField<String> SOURCE_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBClusterSnapshotIdentifier").getter(CopyDbClusterSnapshotRequest.getter(CopyDbClusterSnapshotRequest::sourceDBClusterSnapshotIdentifier)).setter(CopyDbClusterSnapshotRequest.setter(Builder::sourceDBClusterSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBClusterSnapshotIdentifier").build()}).build();
    private static final SdkField<String> TARGET_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDBClusterSnapshotIdentifier").getter(CopyDbClusterSnapshotRequest.getter(CopyDbClusterSnapshotRequest::targetDBClusterSnapshotIdentifier)).setter(CopyDbClusterSnapshotRequest.setter(Builder::targetDBClusterSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBClusterSnapshotIdentifier").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CopyDbClusterSnapshotRequest.getter(CopyDbClusterSnapshotRequest::kmsKeyId)).setter(CopyDbClusterSnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreSignedUrl").getter(CopyDbClusterSnapshotRequest.getter(CopyDbClusterSnapshotRequest::preSignedUrl)).setter(CopyDbClusterSnapshotRequest.setter(Builder::preSignedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTags").getter(CopyDbClusterSnapshotRequest.getter(CopyDbClusterSnapshotRequest::copyTags)).setter(CopyDbClusterSnapshotRequest.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CopyDbClusterSnapshotRequest.getter(CopyDbClusterSnapshotRequest::tags)).setter(CopyDbClusterSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(CopyDbClusterSnapshotRequest.getter(CopyDbClusterSnapshotRequest::sourceRegion)).setter(CopyDbClusterSnapshotRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, TARGET_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, KMS_KEY_ID_FIELD, PRE_SIGNED_URL_FIELD, COPY_TAGS_FIELD, TAGS_FIELD, SOURCE_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopyDbClusterSnapshotRequest.memberNameToFieldInitializer();
    private final String sourceDBClusterSnapshotIdentifier;
    private final String targetDBClusterSnapshotIdentifier;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final Boolean copyTags;
    private final List<Tag> tags;
    private final String sourceRegion;

    private CopyDbClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBClusterSnapshotIdentifier = builder.sourceDBClusterSnapshotIdentifier;
        this.targetDBClusterSnapshotIdentifier = builder.targetDBClusterSnapshotIdentifier;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.copyTags = builder.copyTags;
        this.tags = builder.tags;
        this.sourceRegion = builder.sourceRegion;
    }

    public final String sourceDBClusterSnapshotIdentifier() {
        return this.sourceDBClusterSnapshotIdentifier;
    }

    public final String targetDBClusterSnapshotIdentifier() {
        return this.targetDBClusterSnapshotIdentifier;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String preSignedUrl() {
        return this.preSignedUrl;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbClusterSnapshotRequest)) {
            return false;
        }
        CopyDbClusterSnapshotRequest other = (CopyDbClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceDBClusterSnapshotIdentifier(), other.sourceDBClusterSnapshotIdentifier()) && Objects.equals(this.targetDBClusterSnapshotIdentifier(), other.targetDBClusterSnapshotIdentifier()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.copyTags(), other.copyTags()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sourceRegion(), other.sourceRegion());
    }

    public final String toString() {
        return ToString.builder((String)"CopyDbClusterSnapshotRequest").add("SourceDBClusterSnapshotIdentifier", (Object)this.sourceDBClusterSnapshotIdentifier()).add("TargetDBClusterSnapshotIdentifier", (Object)this.targetDBClusterSnapshotIdentifier()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PreSignedUrl", (Object)this.preSignedUrl()).add("CopyTags", (Object)this.copyTags()).add("Tags", this.hasTags() ? this.tags() : null).add("SourceRegion", (Object)this.sourceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBClusterSnapshotIdentifier()));
            }
            case "TargetDBClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetDBClusterSnapshotIdentifier()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PreSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.preSignedUrl()));
            }
            case "CopyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceDBClusterSnapshotIdentifier", SOURCE_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD);
        map.put("TargetDBClusterSnapshotIdentifier", TARGET_DB_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("PreSignedUrl", PRE_SIGNED_URL_FIELD);
        map.put("CopyTags", COPY_TAGS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SourceRegion", SOURCE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyDbClusterSnapshotRequest, T> g) {
        return obj -> g.apply((CopyDbClusterSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String sourceDBClusterSnapshotIdentifier;
        private String targetDBClusterSnapshotIdentifier;
        private String kmsKeyId;
        private String preSignedUrl;
        private Boolean copyTags;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbClusterSnapshotRequest model) {
            super(model);
            this.sourceDBClusterSnapshotIdentifier(model.sourceDBClusterSnapshotIdentifier);
            this.targetDBClusterSnapshotIdentifier(model.targetDBClusterSnapshotIdentifier);
            this.kmsKeyId(model.kmsKeyId);
            this.preSignedUrl(model.preSignedUrl);
            this.copyTags(model.copyTags);
            this.tags(model.tags);
            this.sourceRegion(model.sourceRegion);
        }

        public final String getSourceDBClusterSnapshotIdentifier() {
            return this.sourceDBClusterSnapshotIdentifier;
        }

        public final void setSourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
            this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
        }

        @Override
        public final Builder sourceDBClusterSnapshotIdentifier(String sourceDBClusterSnapshotIdentifier) {
            this.sourceDBClusterSnapshotIdentifier = sourceDBClusterSnapshotIdentifier;
            return this;
        }

        public final String getTargetDBClusterSnapshotIdentifier() {
            return this.targetDBClusterSnapshotIdentifier;
        }

        public final void setTargetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
            this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
        }

        @Override
        public final Builder targetDBClusterSnapshotIdentifier(String targetDBClusterSnapshotIdentifier) {
            this.targetDBClusterSnapshotIdentifier = targetDBClusterSnapshotIdentifier;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDbClusterSnapshotRequest build() {
            return new CopyDbClusterSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyDbClusterSnapshotRequest> {
        public Builder sourceDBClusterSnapshotIdentifier(String var1);

        public Builder targetDBClusterSnapshotIdentifier(String var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder copyTags(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder sourceRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

