/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import javax.inject.Inject;
import javax.inject.Named;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.opensearch.dataprepper.expression.Evaluator;
import org.opensearch.dataprepper.expression.ExpressionEvaluationException;
import org.opensearch.dataprepper.expression.OperatorProvider;
import org.opensearch.dataprepper.expression.ParseTreeCoercionService;
import org.opensearch.dataprepper.expression.ParseTreeEvaluatorListener;
import org.opensearch.dataprepper.model.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class ParseTreeEvaluator
implements Evaluator<ParseTree, Event> {
    private static final Logger LOG = LoggerFactory.getLogger(ParseTreeEvaluator.class);
    private final OperatorProvider operatorProvider;
    private final ParseTreeWalker walker;
    private final ParseTreeCoercionService coercionService;

    @Inject
    public ParseTreeEvaluator(OperatorProvider operatorProvider, ParseTreeWalker walker, ParseTreeCoercionService coercionService) {
        this.operatorProvider = operatorProvider;
        this.walker = walker;
        this.coercionService = coercionService;
    }

    @Override
    public Object evaluate(ParseTree parseTree, Event event) {
        try {
            ParseTreeEvaluatorListener listener = new ParseTreeEvaluatorListener(this.operatorProvider, this.coercionService, event);
            this.walker.walk((ParseTreeListener)listener, parseTree);
            return listener.getResult();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new ExpressionEvaluationException(e.getMessage(), (Throwable)e);
        }
    }
}

