/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opensearch.dataprepper.expression.ExpressionCoercionException;
import org.opensearch.dataprepper.expression.ExpressionFunctionProvider;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionParser;
import org.opensearch.dataprepper.model.event.Event;

@Named
class ParseTreeCoercionService {
    private final Map<Class<? extends Serializable>, Function<Object, Object>> literalTypeConversions;
    private ExpressionFunctionProvider expressionFunctionProvider;
    private Function<Object, Object> convertLiteralType;

    @Inject
    public ParseTreeCoercionService(Map<Class<? extends Serializable>, Function<Object, Object>> literalTypeConversions, ExpressionFunctionProvider expressionFunctionProvider) {
        this.literalTypeConversions = literalTypeConversions;
        this.convertLiteralType = value -> {
            if (literalTypeConversions.containsKey(value.getClass())) {
                return ((Function)literalTypeConversions.get(value.getClass())).apply(value);
            }
            throw new ExpressionCoercionException("Unsupported type for value " + String.valueOf(value));
        };
        this.expressionFunctionProvider = expressionFunctionProvider;
    }

    public Object coercePrimaryTerminalNode(TerminalNode node, Event event) {
        int nodeType = node.getSymbol().getType();
        String nodeStringValue = node.getText();
        switch (nodeType) {
            case 1: {
                int funcNameIndex = nodeStringValue.indexOf("(");
                String functionName = nodeStringValue.substring(0, funcNameIndex);
                int argsEndIndex = nodeStringValue.indexOf(")", funcNameIndex);
                ArrayList<Object> argList = new ArrayList<Object>();
                if (argsEndIndex > funcNameIndex + 1) {
                    String[] args;
                    String argsStr = nodeStringValue.substring(funcNameIndex + 1, argsEndIndex);
                    for (String arg : args = argsStr.split("(?<!\\\\),")) {
                        String trimmedArg = arg.trim();
                        if (trimmedArg.charAt(0) == '/') {
                            argList.add(trimmedArg);
                            continue;
                        }
                        if (trimmedArg.charAt(0) == '\"') {
                            if (trimmedArg.length() < 2 || trimmedArg.charAt(trimmedArg.length() - 1) != '\"') {
                                throw new RuntimeException("Invalid string argument: check if any argument is missing a closing double quote or contains comma that's not escaped with `\\`.");
                            }
                            argList.add(trimmedArg);
                            continue;
                        }
                        throw new RuntimeException("Unsupported type passed as function argument");
                    }
                }
                return this.expressionFunctionProvider.provideFunction(functionName, argList, event, this.convertLiteralType);
            }
            case 7: {
                String jsonPointerWithoutQuotes = nodeStringValue.substring(1, nodeStringValue.length() - 1);
                return this.resolveJsonPointerValue(jsonPointerWithoutQuotes, event);
            }
            case 6: {
                return this.resolveJsonPointerValue(nodeStringValue, event);
            }
            case 9: {
                String nodeStringValueWithQuotesStripped = nodeStringValue.substring(1, nodeStringValue.length() - 1);
                return nodeStringValueWithQuotesStripped;
            }
            case 2: {
                Long longValue = Long.valueOf(nodeStringValue);
                if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
                    return longValue;
                }
                return Integer.valueOf(nodeStringValue);
            }
            case 3: {
                return Float.valueOf(nodeStringValue);
            }
            case 4: {
                return Boolean.valueOf(nodeStringValue);
            }
            case 11: 
            case 13: {
                return nodeType;
            }
            case 5: {
                return null;
            }
            case 10: {
                return nodeStringValue;
            }
        }
        throw new ExpressionCoercionException("Unsupported terminal node type symbol string: " + DataPrepperExpressionParser.VOCABULARY.getDisplayName(nodeType));
    }

    public <T> T coerce(Object obj, Class<T> clazz) throws ExpressionCoercionException {
        if (obj.getClass().isAssignableFrom(clazz)) {
            return (T)obj;
        }
        throw new ExpressionCoercionException("Unable to cast " + obj.getClass().getName() + " into " + clazz.getName());
    }

    private Object resolveJsonPointerValue(String jsonPointer, Event event) {
        Object value = event.get(jsonPointer, Object.class);
        if (value == null) {
            return null;
        }
        return this.convertLiteralType.apply(value);
    }
}

