/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.inject.Named;
import org.opensearch.dataprepper.expression.AddBinaryOperator;
import org.opensearch.dataprepper.expression.ArithmeticBinaryOperator;
import org.opensearch.dataprepper.expression.ArithmeticSubtractOperator;
import org.opensearch.dataprepper.expression.GenericEqualOperator;
import org.opensearch.dataprepper.expression.GenericInSetOperator;
import org.opensearch.dataprepper.expression.GenericNotOperator;
import org.opensearch.dataprepper.expression.GenericRegexMatchOperator;
import org.opensearch.dataprepper.expression.GenericTypeOfOperator;
import org.opensearch.dataprepper.expression.NumericCompareOperator;
import org.opensearch.dataprepper.expression.Operator;
import org.opensearch.dataprepper.model.event.DataType;
import org.springframework.context.annotation.Bean;

@Named
class OperatorConfiguration {
    public final BiPredicate<Object, Object> regexEquals = (x, y) -> ((String)x).matches((String)y);
    public final BiPredicate<Object, Object> equals = Objects::equals;
    public final BiPredicate<Object, Object> inSet = (x, y) -> ((Set)y).contains(x);
    public final BiPredicate<Object, Object> typeOf = (x, y) -> DataType.isSameType((Object)x, (String)((String)y));

    OperatorConfiguration() {
    }

    @Bean
    public NumericCompareOperator greaterThanOperator() {
        HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Boolean>>> operandsToOperationMap = new HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Boolean>>>();
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> intOperations = Map.of(Integer.class, (lhs, rhs) -> (Integer)lhs > (Integer)rhs, Float.class, (lhs, rhs) -> (float)((Integer)lhs).intValue() > ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (long)((Integer)lhs).intValue() > (Long)rhs, Double.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() > (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> floatOperations = Map.of(Integer.class, (lhs, rhs) -> ((Float)lhs).floatValue() > (float)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> ((Float)lhs).floatValue() > ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> ((Float)lhs).floatValue() > (float)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (double)((Float)lhs).floatValue() > (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> longOperations = Map.of(Integer.class, (lhs, rhs) -> (Long)lhs > (long)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (float)((Long)lhs).longValue() > ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Long)lhs > (Long)rhs, Double.class, (lhs, rhs) -> (double)((Long)lhs).longValue() > (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> doubleOperations = Map.of(Integer.class, (lhs, rhs) -> (Double)lhs > (double)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (Double)lhs > (double)((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Double)lhs > (double)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (Double)lhs > (Double)rhs);
        operandsToOperationMap.put(Integer.class, intOperations);
        operandsToOperationMap.put(Float.class, floatOperations);
        operandsToOperationMap.put(Long.class, longOperations);
        operandsToOperationMap.put(Double.class, doubleOperations);
        return new NumericCompareOperator(17, operandsToOperationMap);
    }

    @Bean
    public NumericCompareOperator greaterThanOrEqualOperator() {
        BiFunction<Object, Object, Boolean> doubleGreaterThanOrEquals = (lhs, rhs) -> ((Number)lhs).doubleValue() >= ((Number)rhs).doubleValue();
        BiFunction<Object, Object, Boolean> floatGreaterThanOrEquals = (lhs, rhs) -> ((Number)lhs).floatValue() >= ((Number)rhs).floatValue();
        HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Boolean>>> operandsToOperationMap = new HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Boolean>>>();
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> intOperations = Map.of(Integer.class, (lhs, rhs) -> (Integer)lhs >= (Integer)rhs, Float.class, (lhs, rhs) -> (float)((Integer)lhs).intValue() >= ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (long)((Integer)lhs).intValue() >= (Long)rhs, Double.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() >= (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> floatOperations = Map.of(Integer.class, (lhs, rhs) -> ((Float)lhs).floatValue() >= (float)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> ((Float)lhs).floatValue() >= ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> ((Float)lhs).floatValue() >= (float)((Long)rhs).longValue(), Double.class, floatGreaterThanOrEquals);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> longOperations = Map.of(Integer.class, (lhs, rhs) -> (Long)lhs >= (long)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (float)((Long)lhs).longValue() >= ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Long)lhs >= (Long)rhs, Double.class, (lhs, rhs) -> (double)((Long)lhs).longValue() >= (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> doubleOperations = Map.of(Integer.class, (lhs, rhs) -> (Double)lhs >= (double)((Integer)rhs).intValue(), Float.class, doubleGreaterThanOrEquals, Long.class, (lhs, rhs) -> (Double)lhs >= (double)((Long)rhs).longValue(), Double.class, doubleGreaterThanOrEquals);
        operandsToOperationMap.put(Integer.class, intOperations);
        operandsToOperationMap.put(Float.class, floatOperations);
        operandsToOperationMap.put(Long.class, longOperations);
        operandsToOperationMap.put(Double.class, doubleOperations);
        return new NumericCompareOperator(19, operandsToOperationMap);
    }

    @Bean
    public NumericCompareOperator lessThanOperator() {
        HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Boolean>>> operandsToOperationMap = new HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Boolean>>>();
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> intOperations = Map.of(Integer.class, (lhs, rhs) -> (Integer)lhs < (Integer)rhs, Float.class, (lhs, rhs) -> (float)((Integer)lhs).intValue() < ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (long)((Integer)lhs).intValue() < (Long)rhs, Double.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() < (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> floatOperations = Map.of(Integer.class, (lhs, rhs) -> ((Float)lhs).floatValue() < (float)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> ((Float)lhs).floatValue() < ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> ((Float)lhs).floatValue() < (float)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (double)((Float)lhs).floatValue() < (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> longOperations = Map.of(Integer.class, (lhs, rhs) -> (Long)lhs < (long)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (float)((Long)lhs).longValue() < ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Long)lhs < (Long)rhs, Double.class, (lhs, rhs) -> (double)((Long)lhs).longValue() < (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> doubleOperations = Map.of(Integer.class, (lhs, rhs) -> (Double)lhs < (double)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (Double)lhs < (double)((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Double)lhs < (double)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (Double)lhs < (Double)rhs);
        operandsToOperationMap.put(Integer.class, intOperations);
        operandsToOperationMap.put(Float.class, floatOperations);
        operandsToOperationMap.put(Long.class, longOperations);
        operandsToOperationMap.put(Double.class, doubleOperations);
        return new NumericCompareOperator(16, operandsToOperationMap);
    }

    @Bean
    public NumericCompareOperator lessThanOrEqualOperator() {
        BiFunction<Object, Object, Boolean> doubleLessThanOrEquals = (lhs, rhs) -> ((Number)lhs).doubleValue() <= ((Number)rhs).doubleValue();
        BiFunction<Object, Object, Boolean> floatLessThanOrEquals = (lhs, rhs) -> ((Number)lhs).floatValue() <= ((Number)rhs).floatValue();
        HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Boolean>>> operandsToOperationMap = new HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Boolean>>>();
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> intOperations = Map.of(Integer.class, (lhs, rhs) -> (Integer)lhs <= (Integer)rhs, Float.class, (lhs, rhs) -> (float)((Integer)lhs).intValue() <= ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (long)((Integer)lhs).intValue() <= (Long)rhs, Double.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() <= (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> floatOperations = Map.of(Integer.class, (lhs, rhs) -> ((Float)lhs).floatValue() <= (float)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> ((Float)lhs).floatValue() <= ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> ((Float)lhs).floatValue() <= (float)((Long)rhs).longValue(), Double.class, floatLessThanOrEquals);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> longOperations = Map.of(Integer.class, (lhs, rhs) -> (Long)lhs <= (long)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (float)((Long)lhs).longValue() <= ((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Long)lhs <= (Long)rhs, Double.class, (lhs, rhs) -> (double)((Long)lhs).longValue() <= (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Boolean>> doubleOperations = Map.of(Integer.class, (lhs, rhs) -> (Double)lhs <= (double)((Integer)rhs).intValue(), Float.class, doubleLessThanOrEquals, Long.class, (lhs, rhs) -> (Double)lhs <= (double)((Long)rhs).longValue(), Double.class, doubleLessThanOrEquals);
        operandsToOperationMap.put(Integer.class, intOperations);
        operandsToOperationMap.put(Float.class, floatOperations);
        operandsToOperationMap.put(Long.class, longOperations);
        operandsToOperationMap.put(Double.class, doubleOperations);
        return new NumericCompareOperator(18, operandsToOperationMap);
    }

    @Bean
    public GenericRegexMatchOperator regexEqualOperator() {
        return new GenericRegexMatchOperator(20, this.regexEquals);
    }

    @Bean
    public GenericRegexMatchOperator regexNotEqualOperator() {
        return new GenericRegexMatchOperator(21, this.regexEquals.negate());
    }

    @Bean
    public GenericEqualOperator equalOperator() {
        BiPredicate<Object, Object> floatEquals = (lhs, rhs) -> ((Number)lhs).floatValue() == ((Number)rhs).floatValue();
        BiPredicate<Object, Object> doubleEquals = (lhs, rhs) -> ((Number)lhs).doubleValue() == ((Number)rhs).doubleValue();
        HashMap equalStrategy = new HashMap();
        HashMap<Class, BiPredicate<Object, Object>> intOperations = new HashMap<Class, BiPredicate<Object, Object>>();
        intOperations.put(Integer.class, (lhs, rhs) -> ((Integer)lhs).intValue() == ((Integer)rhs).intValue());
        intOperations.put(Float.class, floatEquals);
        intOperations.put(Long.class, (lhs, rhs) -> (long)((Integer)lhs).intValue() == (Long)rhs);
        intOperations.put(Double.class, doubleEquals);
        HashMap<Class, BiPredicate<Object, Object>> floatOperations = new HashMap<Class, BiPredicate<Object, Object>>();
        floatOperations.put(Integer.class, floatEquals);
        floatOperations.put(Float.class, floatEquals);
        floatOperations.put(Long.class, floatEquals);
        floatOperations.put(Double.class, floatEquals);
        HashMap<Class, BiPredicate<Object, Object>> longOperations = new HashMap<Class, BiPredicate<Object, Object>>();
        longOperations.put(Integer.class, (lhs, rhs) -> (Long)lhs == (long)((Integer)rhs).intValue());
        longOperations.put(Float.class, floatEquals);
        longOperations.put(Long.class, (lhs, rhs) -> ((Long)lhs).longValue() == ((Long)rhs).longValue());
        longOperations.put(Double.class, doubleEquals);
        HashMap<Class, BiPredicate<Object, Object>> doubleOperations = new HashMap<Class, BiPredicate<Object, Object>>();
        doubleOperations.put(Integer.class, doubleEquals);
        doubleOperations.put(Float.class, floatEquals);
        doubleOperations.put(Long.class, doubleEquals);
        doubleOperations.put(Double.class, doubleEquals);
        equalStrategy.put(Integer.class, intOperations);
        equalStrategy.put(Float.class, floatOperations);
        equalStrategy.put(Long.class, longOperations);
        equalStrategy.put(Double.class, doubleOperations);
        return new GenericEqualOperator(14, 8, equalStrategy);
    }

    @Bean
    public Operator<Boolean> notEqualOperator(GenericEqualOperator equalOperator) {
        return new GenericNotOperator(15, 8, equalOperator);
    }

    @Bean
    public GenericInSetOperator inSetOperator() {
        return new GenericInSetOperator(22, this.inSet);
    }

    @Bean
    public GenericInSetOperator notInSetOperator() {
        return new GenericInSetOperator(23, this.inSet.negate());
    }

    @Bean
    public AddBinaryOperator concatOperator() {
        return new AddBinaryOperator(36, null);
    }

    @Bean
    public GenericTypeOfOperator typeOfOperator() {
        return new GenericTypeOfOperator(24, this.typeOf);
    }

    @Bean
    public AddBinaryOperator addOperator() {
        HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>> operandsToOperationMap = new HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>>();
        Map<Class<Double>, BiFunction<Object, Object, Number>> intOperations = Map.of(Integer.class, (lhs, rhs) -> (Integer)lhs + (Integer)rhs, Float.class, (lhs, rhs) -> Float.valueOf((float)((Integer)lhs).intValue() + ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> (long)((Integer)lhs).intValue() + (Long)rhs, Double.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() + (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> floatOperations = Map.of(Integer.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() + (float)((Integer)rhs).intValue()), Float.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() + ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() + (float)((Long)rhs).longValue()), Double.class, (lhs, rhs) -> (double)((Float)lhs).floatValue() + (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> longOperations = Map.of(Integer.class, (lhs, rhs) -> (Long)lhs + (long)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> Float.valueOf((float)((Long)lhs).longValue() + ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> (Long)lhs + (Long)rhs, Double.class, (lhs, rhs) -> (double)((Long)lhs).longValue() + (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> doubleOperations = Map.of(Integer.class, (lhs, rhs) -> (Double)lhs + (double)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (Double)lhs + (double)((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Double)lhs + (double)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (Double)lhs + (Double)rhs);
        operandsToOperationMap.put(Integer.class, intOperations);
        operandsToOperationMap.put(Float.class, floatOperations);
        operandsToOperationMap.put(Long.class, longOperations);
        operandsToOperationMap.put(Double.class, doubleOperations);
        return new AddBinaryOperator(36, operandsToOperationMap);
    }

    @Bean
    public ArithmeticSubtractOperator subtractOperator() {
        HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>> operandsToOperationMap = new HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>>();
        Map<Class<Double>, BiFunction<Object, Object, Number>> intOperations = Map.of(Integer.class, (lhs, rhs) -> (Integer)lhs - (Integer)rhs, Float.class, (lhs, rhs) -> Float.valueOf((float)((Integer)lhs).intValue() - ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> (long)((Integer)lhs).intValue() - (Long)rhs, Double.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() - (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> floatOperations = Map.of(Integer.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() - (float)((Integer)rhs).intValue()), Float.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() - ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() - (float)((Long)rhs).longValue()), Double.class, (lhs, rhs) -> (double)((Float)lhs).floatValue() - (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> longOperations = Map.of(Integer.class, (lhs, rhs) -> (Long)lhs - (long)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> Float.valueOf((float)((Long)lhs).longValue() - ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> (Long)lhs - (Long)rhs, Double.class, (lhs, rhs) -> (double)((Long)lhs).longValue() - (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> doubleOperations = Map.of(Integer.class, (lhs, rhs) -> (Double)lhs - (double)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (Double)lhs - (double)((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Double)lhs - (double)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (Double)lhs - (Double)rhs);
        operandsToOperationMap.put(Integer.class, intOperations);
        operandsToOperationMap.put(Float.class, floatOperations);
        operandsToOperationMap.put(Long.class, longOperations);
        operandsToOperationMap.put(Double.class, doubleOperations);
        HashMap<Class<? extends Number>, Function<Number, ? extends Number>> strategy = new HashMap<Class<? extends Number>, Function<Number, ? extends Number>>();
        strategy.put(Integer.class, arg -> -arg.intValue());
        strategy.put(Long.class, arg -> -arg.longValue());
        strategy.put(Float.class, arg -> Float.valueOf(-arg.floatValue()));
        return new ArithmeticSubtractOperator(28, operandsToOperationMap, strategy);
    }

    @Bean
    public ArithmeticBinaryOperator multiplyOperator() {
        HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>> operandsToOperationMap = new HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>>();
        Map<Class<Double>, BiFunction<Object, Object, Number>> intOperations = Map.of(Integer.class, (lhs, rhs) -> (Integer)lhs * (Integer)rhs, Float.class, (lhs, rhs) -> Float.valueOf((float)((Integer)lhs).intValue() * ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> (long)((Integer)lhs).intValue() * (Long)rhs, Double.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() * (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> floatOperations = Map.of(Integer.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() * (float)((Integer)rhs).intValue()), Float.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() * ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() * (float)((Long)rhs).longValue()), Double.class, (lhs, rhs) -> (double)((Float)lhs).floatValue() * (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> longOperations = Map.of(Integer.class, (lhs, rhs) -> (Long)lhs * (long)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> Float.valueOf((float)((Long)lhs).longValue() * ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> (Long)lhs * (Long)rhs, Double.class, (lhs, rhs) -> (double)((Long)lhs).longValue() * (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> doubleOperations = Map.of(Integer.class, (lhs, rhs) -> (Double)lhs * (double)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (Double)lhs * (double)((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Double)lhs * (double)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (Double)lhs * (Double)rhs);
        operandsToOperationMap.put(Integer.class, intOperations);
        operandsToOperationMap.put(Float.class, floatOperations);
        operandsToOperationMap.put(Long.class, longOperations);
        operandsToOperationMap.put(Double.class, doubleOperations);
        return new ArithmeticBinaryOperator(37, operandsToOperationMap);
    }

    @Bean
    public ArithmeticBinaryOperator divideOperator() {
        HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>> operandsToOperationMap = new HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>>();
        Map<Class<Double>, BiFunction<Object, Object, Number>> intOperations = Map.of(Integer.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() / (double)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> Float.valueOf((float)((Integer)lhs).intValue() / ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() / (double)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (double)((Integer)lhs).intValue() / (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> floatOperations = Map.of(Integer.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() / (float)((Integer)rhs).intValue()), Float.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() / ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> Float.valueOf(((Float)lhs).floatValue() / (float)((Long)rhs).longValue()), Double.class, (lhs, rhs) -> (double)((Float)lhs).floatValue() / (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> longOperations = Map.of(Integer.class, (lhs, rhs) -> (double)((Long)lhs).longValue() / (double)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> Float.valueOf((float)((Long)lhs).longValue() / ((Float)rhs).floatValue()), Long.class, (lhs, rhs) -> (double)((Long)lhs).longValue() / (double)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (double)((Long)lhs).longValue() / (Double)rhs);
        Map<Class<Double>, BiFunction<Object, Object, Number>> doubleOperations = Map.of(Integer.class, (lhs, rhs) -> (Double)lhs / (double)((Integer)rhs).intValue(), Float.class, (lhs, rhs) -> (Double)lhs / (double)((Float)rhs).floatValue(), Long.class, (lhs, rhs) -> (Double)lhs / (double)((Long)rhs).longValue(), Double.class, (lhs, rhs) -> (Double)lhs / (Double)rhs);
        operandsToOperationMap.put(Integer.class, intOperations);
        operandsToOperationMap.put(Float.class, floatOperations);
        operandsToOperationMap.put(Long.class, longOperations);
        operandsToOperationMap.put(Double.class, doubleOperations);
        return new ArithmeticBinaryOperator(12, operandsToOperationMap);
    }

    @Bean
    public ArithmeticBinaryOperator modOperator() {
        HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>> operandsToOperationMap = new HashMap<Class<? extends Number>, Map<Class<? extends Number>, BiFunction<Object, Object, Number>>>();
        Map<Class<Integer>, BiFunction<Object, Object, Number>> intOperations = Map.of(Integer.class, (lhs, rhs) -> (Integer)lhs % (Integer)rhs);
        operandsToOperationMap.put(Integer.class, intOperations);
        return new ArithmeticBinaryOperator(39, operandsToOperationMap);
    }
}

