/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.dataprepper.expression.ParseTreeCompositeException;
import org.opensearch.dataprepper.expression.Parser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@Named
@Primary
@Scope(value="singleton")
class MultiThreadParser
implements Parser<ParseTree> {
    private final ApplicationContext applicationContext;
    private final ThreadLocal<Parser<ParseTree>> threadLocalParser;

    @Inject
    MultiThreadParser(ApplicationContext applicationContext) {
        this.applicationContext = Objects.requireNonNull(applicationContext);
        this.threadLocalParser = ThreadLocal.withInitial(() -> (Parser)applicationContext.getBean("singleThreadParser", Parser.class));
    }

    @Override
    public ParseTree parse(String expression) throws ParseTreeCompositeException {
        return this.threadLocalParser.get().parse(expression);
    }
}

