/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.opensearch.dataprepper.expression.ExpressionFunction;
import org.opensearch.dataprepper.model.event.Event;

@Named
public class JoinExpressionFunction
implements ExpressionFunction {
    private static final String FUNCTION_NAME = "join";

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Object evaluate(List<Object> args, Event event, Function<Object, Object> convertLiteralType) {
        String sourceKey;
        String delimiter;
        List argStrings;
        if (args.isEmpty() || args.size() > 2) {
            throw new IllegalArgumentException("join() takes one or two arguments");
        }
        try {
            argStrings = args.stream().map(arg -> ((String)arg).trim()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Arguments in join() function should be of Json Pointer type or String type");
        }
        if (argStrings.size() == 2) {
            String trimmedDelimiter = ((String)argStrings.get(0)).substring(1, ((String)argStrings.get(0)).length() - 1);
            delimiter = trimmedDelimiter.replace("\\\\,", ",");
            sourceKey = (String)argStrings.get(1);
        } else {
            delimiter = ",";
            sourceKey = (String)argStrings.get(0);
        }
        try {
            if (event.isValueAList(sourceKey)) {
                List sourceList = (List)event.get(sourceKey, List.class);
                return this.joinList(sourceList, delimiter);
            }
            Map sourceMap = (Map)event.get(sourceKey, Map.class);
            return this.joinListsInMap(sourceMap, delimiter);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to perform join function on " + sourceKey, ex);
        }
    }

    private String joinList(List<Object> sourceList, String delimiter) {
        List stringList = sourceList.stream().map(Object::toString).collect(Collectors.toList());
        return String.join((CharSequence)delimiter, stringList);
    }

    private Map<String, Object> joinListsInMap(Map<String, Object> sourceMap, String delimiter) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            try {
                String joinedEntryValue = this.joinList((List)entry.getValue(), delimiter);
                resultMap.put(entry.getKey(), joinedEntryValue);
            }
            catch (Exception e) {
                resultMap.put(entry.getKey(), entry.getValue());
            }
        }
        return resultMap;
    }
}

