/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import com.google.common.base.Preconditions;
import org.antlr.v4.runtime.RuleContext;
import org.opensearch.dataprepper.expression.Operator;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionParser;

abstract class BinaryOperator<T>
implements Operator<T> {
    private final int symbol;
    private final int shouldEvaluateRuleIndex;
    protected final String displayName;

    protected BinaryOperator(int symbol, int shouldEvaluateRuleIndex) {
        this.symbol = symbol;
        this.shouldEvaluateRuleIndex = shouldEvaluateRuleIndex;
        this.displayName = DataPrepperExpressionParser.VOCABULARY.getDisplayName(symbol);
    }

    @Override
    public boolean shouldEvaluate(RuleContext ctx) {
        return ctx.getRuleIndex() == this.shouldEvaluateRuleIndex;
    }

    @Override
    public int getSymbol() {
        return this.symbol;
    }

    @Override
    public T evaluate(Object ... args) {
        Preconditions.checkArgument((args.length == this.getNumberOfOperands(null) ? 1 : 0) != 0, (Object)(this.displayName + " requires operands length to be " + this.getNumberOfOperands(null) + "."));
        return this.checkedEvaluate(args[0], args[1]);
    }

    abstract T checkedEvaluate(Object var1, Object var2);
}

