/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws.sqs.common.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import org.opensearch.dataprepper.metrics.PluginMetrics;

public class SqsMetrics {
    public static final String SQS_MESSAGES_RECEIVED_METRIC_NAME = "sqsMessagesReceived";
    public static final String SQS_MESSAGES_DELETED_METRIC_NAME = "sqsMessagesDeleted";
    public static final String SQS_RECEIVE_MESSAGES_FAILED_METRIC_NAME = "sqsReceiveMessageFailed";
    public static final String SQS_MESSAGES_DELETE_FAILED_METRIC_NAME = "sqsMessagesDeleteFailed";
    public static final String SQS_MESSAGE_DELAY_METRIC_NAME = "sqsMessageDelay";
    public static final String ACKNOWLEDGEMENT_SET_CALLBACK_METRIC_NAME = "acknowledgementSetCallbackCounter";
    private final Counter sqsMessagesReceivedCounter;
    private final Counter sqsMessagesDeletedCounter;
    private final Counter sqsReceiveMessagesFailedCounter;
    private final Counter sqsMessagesDeleteFailedCounter;
    private final Counter acknowledgementSetCallbackCounter;
    private final Timer sqsMessageDelayTimer;

    public SqsMetrics(PluginMetrics pluginMetrics) {
        this.sqsMessagesReceivedCounter = pluginMetrics.counter(SQS_MESSAGES_RECEIVED_METRIC_NAME);
        this.sqsMessagesDeletedCounter = pluginMetrics.counter(SQS_MESSAGES_DELETED_METRIC_NAME);
        this.sqsReceiveMessagesFailedCounter = pluginMetrics.counter(SQS_RECEIVE_MESSAGES_FAILED_METRIC_NAME);
        this.sqsMessagesDeleteFailedCounter = pluginMetrics.counter(SQS_MESSAGES_DELETE_FAILED_METRIC_NAME);
        this.sqsMessageDelayTimer = pluginMetrics.timer(SQS_MESSAGE_DELAY_METRIC_NAME);
        this.acknowledgementSetCallbackCounter = pluginMetrics.counter(ACKNOWLEDGEMENT_SET_CALLBACK_METRIC_NAME);
    }

    public Counter getSqsMessagesReceivedCounter() {
        return this.sqsMessagesReceivedCounter;
    }

    public Counter getSqsMessagesDeletedCounter() {
        return this.sqsMessagesDeletedCounter;
    }

    public Counter getSqsReceiveMessagesFailedCounter() {
        return this.sqsReceiveMessagesFailedCounter;
    }

    public Counter getSqsMessagesDeleteFailedCounter() {
        return this.sqsMessagesDeleteFailedCounter;
    }

    public Counter getAcknowledgementSetCallbackCounter() {
        return this.acknowledgementSetCallbackCounter;
    }

    public Timer getSqsMessageDelayTimer() {
        return this.sqsMessageDelayTimer;
    }
}

