/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalizeevents.model.ImpressionCopier;
import software.amazon.awssdk.services.personalizeevents.model.MetricAttribution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(Event.getter(Event::eventId)).setter(Event.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(Event.getter(Event::eventType)).setter(Event.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<Float> EVENT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("eventValue").getter(Event.getter(Event::eventValue)).setter(Event.setter(Builder::eventValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventValue").build()}).build();
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("itemId").getter(Event.getter(Event::itemId)).setter(Event.setter(Builder::itemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()}).build();
    private static final SdkField<String> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("properties").getter(Event.getter(Event::properties)).setter(Event.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), JsonValueTrait.create()}).build();
    private static final SdkField<Instant> SENT_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("sentAt").getter(Event.getter(Event::sentAt)).setter(Event.setter(Builder::sentAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentAt").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(Event.getter(Event::recommendationId)).setter(Event.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final SdkField<List<String>> IMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impression").getter(Event.getter(Event::impression)).setter(Event.setter(Builder::impression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impression").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MetricAttribution> METRIC_ATTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metricAttribution").getter(Event.getter(Event::metricAttribution)).setter(Event.setter(Builder::metricAttribution)).constructor(MetricAttribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAttribution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_TYPE_FIELD, EVENT_VALUE_FIELD, ITEM_ID_FIELD, PROPERTIES_FIELD, SENT_AT_FIELD, RECOMMENDATION_ID_FIELD, IMPRESSION_FIELD, METRIC_ATTRIBUTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Event.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String eventType;
    private final Float eventValue;
    private final String itemId;
    private final String properties;
    private final Instant sentAt;
    private final String recommendationId;
    private final List<String> impression;
    private final MetricAttribution metricAttribution;

    private Event(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.eventValue = builder.eventValue;
        this.itemId = builder.itemId;
        this.properties = builder.properties;
        this.sentAt = builder.sentAt;
        this.recommendationId = builder.recommendationId;
        this.impression = builder.impression;
        this.metricAttribution = builder.metricAttribution;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final Float eventValue() {
        return this.eventValue;
    }

    public final String itemId() {
        return this.itemId;
    }

    public final String properties() {
        return this.properties;
    }

    public final Instant sentAt() {
        return this.sentAt;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final boolean hasImpression() {
        return this.impression != null && !(this.impression instanceof SdkAutoConstructList);
    }

    public final List<String> impression() {
        return this.impression;
    }

    public final MetricAttribution metricAttribution() {
        return this.metricAttribution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpression() ? this.impression() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAttribution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.eventValue(), other.eventValue()) && Objects.equals(this.itemId(), other.itemId()) && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.sentAt(), other.sentAt()) && Objects.equals(this.recommendationId(), other.recommendationId()) && this.hasImpression() == other.hasImpression() && Objects.equals(this.impression(), other.impression()) && Objects.equals(this.metricAttribution(), other.metricAttribution());
    }

    public final String toString() {
        return ToString.builder((String)"Event").add("EventId", (Object)this.eventId()).add("EventType", (Object)this.eventType()).add("EventValue", (Object)this.eventValue()).add("ItemId", (Object)(this.itemId() == null ? null : "*** Sensitive Data Redacted ***")).add("Properties", (Object)(this.properties() == null ? null : "*** Sensitive Data Redacted ***")).add("SentAt", (Object)this.sentAt()).add("RecommendationId", (Object)this.recommendationId()).add("Impression", (Object)(this.impression() == null ? null : "*** Sensitive Data Redacted ***")).add("MetricAttribution", (Object)this.metricAttribution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "eventValue": {
                return Optional.ofNullable(clazz.cast(this.eventValue()));
            }
            case "itemId": {
                return Optional.ofNullable(clazz.cast(this.itemId()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "sentAt": {
                return Optional.ofNullable(clazz.cast(this.sentAt()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "impression": {
                return Optional.ofNullable(clazz.cast(this.impression()));
            }
            case "metricAttribution": {
                return Optional.ofNullable(clazz.cast(this.metricAttribution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventId", EVENT_ID_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("eventValue", EVENT_VALUE_FIELD);
        map.put("itemId", ITEM_ID_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("sentAt", SENT_AT_FIELD);
        map.put("recommendationId", RECOMMENDATION_ID_FIELD);
        map.put("impression", IMPRESSION_FIELD);
        map.put("metricAttribution", METRIC_ATTRIBUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String eventType;
        private Float eventValue;
        private String itemId;
        private String properties;
        private Instant sentAt;
        private String recommendationId;
        private List<String> impression = DefaultSdkAutoConstructList.getInstance();
        private MetricAttribution metricAttribution;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.eventId(model.eventId);
            this.eventType(model.eventType);
            this.eventValue(model.eventValue);
            this.itemId(model.itemId);
            this.properties(model.properties);
            this.sentAt(model.sentAt);
            this.recommendationId(model.recommendationId);
            this.impression(model.impression);
            this.metricAttribution(model.metricAttribution);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final Float getEventValue() {
            return this.eventValue;
        }

        public final void setEventValue(Float eventValue) {
            this.eventValue = eventValue;
        }

        @Override
        public final Builder eventValue(Float eventValue) {
            this.eventValue = eventValue;
            return this;
        }

        public final String getItemId() {
            return this.itemId;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final String getProperties() {
            return this.properties;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public final Instant getSentAt() {
            return this.sentAt;
        }

        public final void setSentAt(Instant sentAt) {
            this.sentAt = sentAt;
        }

        @Override
        public final Builder sentAt(Instant sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final Collection<String> getImpression() {
            if (this.impression instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impression;
        }

        public final void setImpression(Collection<String> impression) {
            this.impression = ImpressionCopier.copy(impression);
        }

        @Override
        public final Builder impression(Collection<String> impression) {
            this.impression = ImpressionCopier.copy(impression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impression(String ... impression) {
            this.impression(Arrays.asList(impression));
            return this;
        }

        public final MetricAttribution.Builder getMetricAttribution() {
            return this.metricAttribution != null ? this.metricAttribution.toBuilder() : null;
        }

        public final void setMetricAttribution(MetricAttribution.BuilderImpl metricAttribution) {
            this.metricAttribution = metricAttribution != null ? metricAttribution.build() : null;
        }

        @Override
        public final Builder metricAttribution(MetricAttribution metricAttribution) {
            this.metricAttribution = metricAttribution;
            return this;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder eventId(String var1);

        public Builder eventType(String var1);

        public Builder eventValue(Float var1);

        public Builder itemId(String var1);

        public Builder properties(String var1);

        public Builder sentAt(Instant var1);

        public Builder recommendationId(String var1);

        public Builder impression(Collection<String> var1);

        public Builder impression(String ... var1);

        public Builder metricAttribution(MetricAttribution var1);

        default public Builder metricAttribution(Consumer<MetricAttribution.Builder> metricAttribution) {
            return this.metricAttribution((MetricAttribution)((MetricAttribution.Builder)MetricAttribution.builder().applyMutation(metricAttribution)).build());
        }
    }
}

