/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.metric.DefaultExemplar;
import org.opensearch.dataprepper.model.metric.Exemplar;
import org.opensearch.dataprepper.model.metric.JacksonSum;
import org.opensearch.dataprepper.model.trace.Span;
import org.opensearch.dataprepper.plugins.hasher.IdentificationKeysHasher;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCommonUtils;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionInput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionOutput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateProcessor;
import org.opensearch.dataprepper.plugins.processor.aggregate.GroupState;
import org.opensearch.dataprepper.plugins.processor.aggregate.actions.CountAggregateActionConfig;
import org.opensearch.dataprepper.plugins.processor.aggregate.actions.OutputFormat;

@DataPrepperPlugin(name="count", pluginType=AggregateAction.class, pluginConfigurationType=CountAggregateActionConfig.class)
public class CountAggregateAction
implements AggregateAction {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final String UNIQUE_KEYS_SETKEY = "__unique_keys";
    private static final String exemplarKey = "__exemplar";
    static final String EVENT_TYPE = "event";
    static final String SUM_METRIC_DESCRIPTION = "Number of events";
    static final String SUM_METRIC_UNIT = "1";
    static final boolean SUM_METRIC_IS_MONOTONIC = true;
    public final String countKey;
    public final String startTimeKey;
    public final String endTimeKey;
    public final OutputFormat outputFormat;
    private long startTimeNanos;
    private final String metricName;
    private final IdentificationKeysHasher uniqueKeysHasher;

    @DataPrepperPluginConstructor
    public CountAggregateAction(CountAggregateActionConfig countAggregateActionConfig) {
        this.countKey = countAggregateActionConfig.getCountKey();
        this.startTimeKey = countAggregateActionConfig.getStartTimeKey();
        this.endTimeKey = countAggregateActionConfig.getEndTimeKey();
        this.outputFormat = countAggregateActionConfig.getOutputFormat();
        this.metricName = countAggregateActionConfig.getMetricName();
        this.uniqueKeysHasher = countAggregateActionConfig.getUniqueKeys() != null ? new IdentificationKeysHasher(countAggregateActionConfig.getUniqueKeys()) : null;
    }

    public Exemplar createExemplar(Event event) {
        long curTimeNanos = AggregateProcessor.getTimeNanos(Instant.now());
        Map attributes = event.toMap();
        String spanId = null;
        String traceId = null;
        if (event instanceof Span) {
            Span span = (Span)event;
            spanId = span.getSpanId();
            traceId = span.getTraceId();
        }
        return new DefaultExemplar(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)curTimeNanos), Double.valueOf(1.0), spanId, traceId, attributes);
    }

    @Override
    public AggregateActionResponse handleEvent(Event event, AggregateActionInput aggregateActionInput) {
        Instant eventStartTime;
        GroupState groupState = aggregateActionInput.getGroupState();
        Instant eventEndTime = eventStartTime = Instant.now();
        Object startTime = event.get(this.startTimeKey, Object.class);
        Object endTime = event.get(this.endTimeKey, Object.class);
        if (startTime != null) {
            eventStartTime = AggregateProcessor.convertObjectToInstant(startTime);
        }
        if (endTime != null) {
            eventEndTime = AggregateProcessor.convertObjectToInstant(endTime);
        }
        if (groupState.get(this.countKey) == null) {
            groupState.putAll(aggregateActionInput.getIdentificationKeys());
            if (this.uniqueKeysHasher != null) {
                HashSet<IdentificationKeysHasher.IdentificationKeysMap> uniqueKeysMapSet = new HashSet<IdentificationKeysHasher.IdentificationKeysMap>();
                uniqueKeysMapSet.add(this.uniqueKeysHasher.createIdentificationKeysMapFromEvent(event));
                groupState.put(UNIQUE_KEYS_SETKEY, uniqueKeysMapSet);
            }
            groupState.put(this.countKey, 1);
            groupState.put(exemplarKey, this.createExemplar(event));
            groupState.put(this.startTimeKey, eventStartTime);
            groupState.put(this.endTimeKey, eventEndTime);
        } else {
            Integer v = (Integer)groupState.get(this.countKey) + 1;
            if (this.uniqueKeysHasher != null) {
                Set uniqueKeysMapSet = (Set)groupState.get(UNIQUE_KEYS_SETKEY);
                uniqueKeysMapSet.add(this.uniqueKeysHasher.createIdentificationKeysMapFromEvent(event));
                v = uniqueKeysMapSet.size();
            }
            groupState.put(this.countKey, v);
            Instant groupStartTime = (Instant)groupState.get(this.startTimeKey);
            Instant groupEndTime = (Instant)groupState.get(this.endTimeKey);
            if (eventStartTime.isBefore(groupStartTime)) {
                groupState.put(this.startTimeKey, eventStartTime);
            }
            if (eventEndTime.isAfter(groupEndTime)) {
                groupState.put(this.endTimeKey, eventEndTime);
            }
        }
        return AggregateActionResponse.nullEventResponse();
    }

    @Override
    public AggregateActionOutput concludeGroup(AggregateActionInput aggregateActionInput) {
        JacksonEvent event;
        GroupState groupState = aggregateActionInput.getGroupState();
        Instant startTime = (Instant)groupState.get(this.startTimeKey);
        Instant endTime = (Instant)groupState.get(this.endTimeKey);
        groupState.remove(this.endTimeKey);
        groupState.remove(UNIQUE_KEYS_SETKEY);
        if (this.outputFormat == OutputFormat.RAW) {
            groupState.put(this.startTimeKey, startTime.atZone(ZoneId.of(ZoneId.systemDefault().toString())).format(DateTimeFormatter.ofPattern(DATE_FORMAT)));
            event = JacksonEvent.builder().withEventType(EVENT_TYPE).withData((Object)groupState).withEventHandle(aggregateActionInput.getEventHandle()).build();
        } else {
            Integer countValue = (Integer)groupState.get(this.countKey);
            Exemplar exemplar = (Exemplar)groupState.get(exemplarKey);
            groupState.remove(exemplarKey);
            groupState.remove(this.countKey);
            groupState.remove(this.startTimeKey);
            long endTimeNanos = AggregateProcessor.getTimeNanos(endTime);
            long startTimeNanos = AggregateProcessor.getTimeNanos(startTime);
            HashMap attr = new HashMap();
            groupState.forEach((k, v) -> attr.put((String)k, v));
            JacksonSum sum = ((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)((JacksonSum.Builder)JacksonSum.builder().withName(this.metricName)).withDescription(SUM_METRIC_DESCRIPTION)).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)endTimeNanos))).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)startTimeNanos))).withIsMonotonic(true).withUnit(SUM_METRIC_UNIT)).withAggregationTemporality(AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA.name()).withValue(Double.valueOf(countValue.intValue())).withExemplars(List.of(exemplar))).withAttributes(attr)).withEventHandle(aggregateActionInput.getEventHandle())).build(false);
            event = sum;
        }
        return new AggregateActionOutput(List.of(event));
    }
}

