/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sourcecoordinator.dynamodb;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.source.SourceCoordinationStore;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStatus;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.plugins.sourcecoordinator.dynamodb.DynamoDbClientWrapper;
import org.opensearch.dataprepper.plugins.sourcecoordinator.dynamodb.DynamoDbSourcePartitionItem;
import org.opensearch.dataprepper.plugins.sourcecoordinator.dynamodb.DynamoStoreSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;

@DataPrepperPlugin(name="dynamodb", pluginType=SourceCoordinationStore.class, pluginConfigurationType=DynamoStoreSettings.class)
public class DynamoDbSourceCoordinationStore
implements SourceCoordinationStore {
    private static final Logger LOG = LoggerFactory.getLogger(DynamoDbSourceCoordinationStore.class);
    private final DynamoStoreSettings dynamoStoreSettings;
    private final PluginMetrics pluginMetrics;
    private final DynamoDbClientWrapper dynamoDbClientWrapper;
    static final String SOURCE_STATUS_COMBINATION_KEY_FORMAT = "%s|%s";

    @DataPrepperPluginConstructor
    public DynamoDbSourceCoordinationStore(DynamoStoreSettings dynamoStoreSettings, PluginMetrics pluginMetrics) {
        this.dynamoStoreSettings = dynamoStoreSettings;
        this.pluginMetrics = pluginMetrics;
        this.dynamoDbClientWrapper = DynamoDbClientWrapper.create(dynamoStoreSettings.getRegion(), dynamoStoreSettings.getStsRoleArn(), dynamoStoreSettings.getStsExternalId());
    }

    public void initializeStore() {
        this.dynamoDbClientWrapper.initializeTable(this.dynamoStoreSettings, this.constructProvisionedThroughput(this.dynamoStoreSettings.getProvisionedReadCapacityUnits(), this.dynamoStoreSettings.getProvisionedWriteCapacityUnits()));
    }

    public Optional<SourcePartitionStoreItem> getSourcePartitionItem(String sourceIdentifier, String sourcePartitionKey) {
        return this.dynamoDbClientWrapper.getSourcePartitionItem(sourceIdentifier, sourcePartitionKey);
    }

    public List<SourcePartitionStoreItem> querySourcePartitionItemsByStatus(String sourceIdentifier, SourcePartitionStatus sourcePartitionStatus, String startPartitionPriority) {
        String statusKey = String.format(SOURCE_STATUS_COMBINATION_KEY_FORMAT, sourceIdentifier, sourcePartitionStatus);
        return this.dynamoDbClientWrapper.queryPartitionsByStatus(statusKey, startPartitionPriority);
    }

    public List<SourcePartitionStoreItem> queryAllSourcePartitionItems(String sourceIdentifier) {
        return this.dynamoDbClientWrapper.queryAllPartitions(sourceIdentifier);
    }

    public boolean tryCreatePartitionItem(String sourceIdentifier, String sourcePartitionKey, SourcePartitionStatus sourcePartitionStatus, Long closedCount, String partitionProgressState, boolean isReadOnlyItem) {
        DynamoDbSourcePartitionItem newPartitionItem = new DynamoDbSourcePartitionItem();
        if (!isReadOnlyItem && Objects.nonNull(this.dynamoStoreSettings.getTtl())) {
            newPartitionItem.setExpirationTime(Instant.now().plus(this.dynamoStoreSettings.getTtl()).getEpochSecond());
        }
        newPartitionItem.setSourceIdentifier(sourceIdentifier);
        newPartitionItem.setSourceStatusCombinationKey(String.format(SOURCE_STATUS_COMBINATION_KEY_FORMAT, sourceIdentifier, sourcePartitionStatus));
        newPartitionItem.setPartitionPriority(Instant.now().toString());
        newPartitionItem.setSourcePartitionKey(sourcePartitionKey);
        newPartitionItem.setSourcePartitionStatus(sourcePartitionStatus);
        newPartitionItem.setClosedCount(closedCount);
        newPartitionItem.setPartitionProgressState(partitionProgressState);
        newPartitionItem.setVersion(0L);
        return this.dynamoDbClientWrapper.tryCreatePartitionItem(newPartitionItem);
    }

    public Optional<SourcePartitionStoreItem> tryAcquireAvailablePartition(String sourceIdentifier, String ownerId, Duration ownershipTimeout) {
        Optional<SourcePartitionStoreItem> acquiredAssignedItem = this.dynamoDbClientWrapper.getAvailablePartition(ownerId, ownershipTimeout, SourcePartitionStatus.ASSIGNED, String.format(SOURCE_STATUS_COMBINATION_KEY_FORMAT, sourceIdentifier, SourcePartitionStatus.ASSIGNED), 1, this.dynamoStoreSettings.getTtl());
        if (acquiredAssignedItem.isPresent()) {
            return acquiredAssignedItem;
        }
        Optional<SourcePartitionStoreItem> acquiredUnassignedItem = this.dynamoDbClientWrapper.getAvailablePartition(ownerId, ownershipTimeout, SourcePartitionStatus.UNASSIGNED, String.format(SOURCE_STATUS_COMBINATION_KEY_FORMAT, sourceIdentifier, SourcePartitionStatus.UNASSIGNED), 5, this.dynamoStoreSettings.getTtl());
        if (acquiredUnassignedItem.isPresent()) {
            return acquiredUnassignedItem;
        }
        return this.dynamoDbClientWrapper.getAvailablePartition(ownerId, ownershipTimeout, SourcePartitionStatus.CLOSED, String.format(SOURCE_STATUS_COMBINATION_KEY_FORMAT, sourceIdentifier, SourcePartitionStatus.CLOSED), 1, this.dynamoStoreSettings.getTtl());
    }

    public void tryUpdateSourcePartitionItem(SourcePartitionStoreItem updateItem) {
        this.tryUpdateSourcePartitionItemInternal(updateItem, null);
    }

    public void tryUpdateSourcePartitionItem(SourcePartitionStoreItem updateItem, Instant priorityOverride) {
        this.tryUpdateSourcePartitionItemInternal(updateItem, priorityOverride);
    }

    private void tryUpdateSourcePartitionItemInternal(SourcePartitionStoreItem updateItem, Instant priorityOverride) {
        DynamoDbSourcePartitionItem dynamoDbSourcePartitionItem = (DynamoDbSourcePartitionItem)updateItem;
        dynamoDbSourcePartitionItem.setSourceStatusCombinationKey(String.format(SOURCE_STATUS_COMBINATION_KEY_FORMAT, updateItem.getSourceIdentifier(), updateItem.getSourcePartitionStatus()));
        if (SourcePartitionStatus.CLOSED.equals((Object)updateItem.getSourcePartitionStatus())) {
            dynamoDbSourcePartitionItem.setPartitionPriority(updateItem.getReOpenAt().toString());
        }
        if (SourcePartitionStatus.ASSIGNED.equals((Object)updateItem.getSourcePartitionStatus())) {
            dynamoDbSourcePartitionItem.setPartitionPriority(updateItem.getPartitionOwnershipTimeout().toString());
        }
        if (priorityOverride != null && SourcePartitionStatus.UNASSIGNED.equals((Object)updateItem.getSourcePartitionStatus())) {
            dynamoDbSourcePartitionItem.setPartitionPriority(priorityOverride.toString());
        }
        if (Objects.nonNull(this.dynamoStoreSettings.getTtl())) {
            dynamoDbSourcePartitionItem.setExpirationTime(Instant.now().plus(this.dynamoStoreSettings.getTtl()).getEpochSecond());
        }
        this.dynamoDbClientWrapper.tryUpdatePartitionItem(dynamoDbSourcePartitionItem);
    }

    public void tryDeletePartitionItem(SourcePartitionStoreItem deleteItem) {
        this.dynamoDbClientWrapper.tryDeletePartitionItem((DynamoDbSourcePartitionItem)deleteItem);
    }

    private ProvisionedThroughput constructProvisionedThroughput(Long readCapacityUnits, Long writeCapacityUnits) {
        return (ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(readCapacityUnits).writeCapacityUnits(writeCapacityUnits).build();
    }
}

