/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.event;

import javax.inject.Named;
import org.opensearch.dataprepper.core.event.CachingEventKeyFactory;
import org.opensearch.dataprepper.core.event.DefaultEventKeyFactory;
import org.opensearch.dataprepper.core.event.EventConfiguration;
import org.opensearch.dataprepper.core.event.EventConfigurationContainer;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
class EventFactoryApplicationConfiguration {
    EventFactoryApplicationConfiguration() {
    }

    @Bean
    EventConfiguration eventConfiguration(@Autowired(required=false) EventConfigurationContainer eventConfigurationContainer) {
        if (eventConfigurationContainer == null || eventConfigurationContainer.getEventConfiguration() == null) {
            return EventConfiguration.defaultConfiguration();
        }
        return eventConfigurationContainer.getEventConfiguration();
    }

    @Bean(name={"innerEventKeyFactory"})
    EventKeyFactory innerEventKeyFactory() {
        return new DefaultEventKeyFactory();
    }

    @Primary
    @Bean(name={"eventKeyFactory"})
    EventKeyFactory eventKeyFactory(@Named(value="innerEventKeyFactory") EventKeyFactory eventKeyFactory, EventConfiguration eventConfiguration) {
        if (eventConfiguration.getMaximumCachedKeys() <= 0) {
            return eventKeyFactory;
        }
        return new CachingEventKeyFactory(eventKeyFactory, eventConfiguration);
    }
}

