/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.event;

import org.opensearch.dataprepper.core.event.DefaultBaseEventBuilder;
import org.opensearch.dataprepper.core.event.EventBuilderFactory;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventBuilder;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.springframework.stereotype.Component;

@Component
class DefaultEventBuilderFactory
extends EventBuilderFactory {
    static final String EVENT_TYPE = "EVENT";

    DefaultEventBuilderFactory() {
    }

    @Override
    Class<?> getEventClass() {
        return EventBuilder.class;
    }

    @Override
    DefaultBaseEventBuilder createNew() {
        return new DefaultEventBuilder();
    }

    public static class DefaultEventBuilder
    extends DefaultBaseEventBuilder<Event>
    implements EventBuilder {
        @Override
        String getDefaultEventType() {
            return DefaultEventBuilderFactory.EVENT_TYPE;
        }

        public Event build() {
            return JacksonEvent.builder().withEventMetadata(this.getEventMetadata()).withData(this.getData()).build();
        }
    }
}

