/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.event;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.dataprepper.model.event.BaseEventBuilder;
import org.opensearch.dataprepper.model.event.DefaultEventMetadata;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.event.EventMetadata;

abstract class DefaultBaseEventBuilder<T extends Event>
implements BaseEventBuilder<T> {
    private EventMetadata eventMetadata;
    private Object data;
    private String eventType;
    private Instant timeReceived;
    private EventHandle eventHandle;
    private Map<String, Object> attributes;

    public DefaultBaseEventBuilder() {
        this.withTimeReceived(Instant.now());
    }

    public Object getData() {
        return this.data;
    }

    public String getEventType() {
        return this.eventType;
    }

    abstract String getDefaultEventType();

    public EventMetadata getEventMetadata() {
        if (this.eventMetadata == null) {
            this.eventMetadata = new DefaultEventMetadata.Builder().withEventType(this.eventType != null ? this.eventType : this.getDefaultEventType()).withTimeReceived(this.timeReceived).withAttributes(this.attributes).build();
        }
        return this.eventMetadata;
    }

    public Instant getTimeReceived() {
        return this.timeReceived;
    }

    public Map<String, Object> getEventMetadataAttributes() {
        return this.attributes;
    }

    public BaseEventBuilder<T> withEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public BaseEventBuilder<T> withEventMetadataAttributes(Map<String, Object> eventMetadataAttributes) {
        this.attributes = eventMetadataAttributes;
        return this;
    }

    public BaseEventBuilder<T> withTimeReceived(Instant timeReceived) {
        this.timeReceived = timeReceived;
        return this;
    }

    public BaseEventBuilder<T> withEventMetadata(EventMetadata eventMetadata) {
        this.eventType = eventMetadata.getEventType();
        this.timeReceived = eventMetadata.getTimeReceived();
        this.attributes = new HashMap<String, Object>(eventMetadata.getAttributes());
        return this;
    }

    public BaseEventBuilder<T> withData(Object data) {
        this.data = data;
        return this;
    }

    public BaseEventBuilder<T> withEventHandle(EventHandle eventHandle) {
        this.eventHandle = eventHandle;
        return this;
    }
}

