/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper;

import java.nio.file.Paths;
import java.security.Security;
import org.opensearch.dataprepper.ContextManager;
import org.opensearch.dataprepper.core.DataPrepper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ComponentScan;

@ComponentScan
public class DataPrepperExecute {
    private static final Logger LOG = LoggerFactory.getLogger(DataPrepperExecute.class);

    public static void main(String ... args) {
        ContextManager contextManager;
        Security.setProperty("networkaddress.cache.ttl", "60");
        System.setProperty("software.amazon.awssdk.http.service.impl", "software.amazon.awssdk.http.apache.ApacheSdkHttpService");
        if (args.length == 0) {
            String dataPrepperHome = System.getProperty("data-prepper.dir");
            if (dataPrepperHome == null) {
                throw new RuntimeException("Data Prepper home directory (data-prepper.dir) not set in system properties.");
            }
            String dataPrepperPipelines = Paths.get(dataPrepperHome, new String[0]).resolve("pipelines/").toString();
            String dataPrepperConfig = Paths.get(dataPrepperHome, new String[0]).resolve("config/data-prepper-config.yaml").toString();
            contextManager = new ContextManager(dataPrepperPipelines, dataPrepperConfig);
        } else {
            contextManager = new ContextManager(args);
        }
        DataPrepper dataPrepper = contextManager.getDataPrepperBean();
        LOG.trace("Starting Data Prepper execution");
        dataPrepper.execute();
    }
}

