/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.logstash.mapping.NestedSyntaxConverter;

class GrokMatchUtil {
    private static final String GROK_MATCH_PATTERN_REGEX = "(%\\{)([^{}:]+)(:)?([^{}:]+)?(:)?([a-zA-Z]+)?(}(\\s+)?)";
    private static final Pattern GROK_MATCH_PATTERN = Pattern.compile("(%\\{)([^{}:]+)(:)?([^{}:]+)?(:)?([a-zA-Z]+)?(}(\\s+)?)");
    private static final String SEPARATOR = ":";

    private GrokMatchUtil() {
    }

    public static String convertGrokMatchPattern(String matchPattern) {
        StringBuilder convertedGrokMatchPattern = new StringBuilder();
        Matcher grokMatchPatternMatcher = GROK_MATCH_PATTERN.matcher(matchPattern);
        while (grokMatchPatternMatcher.find()) {
            convertedGrokMatchPattern.append(GrokMatchUtil.getConvertedMatchPattern(grokMatchPatternMatcher.group()));
        }
        if (convertedGrokMatchPattern.toString().isEmpty()) {
            return matchPattern;
        }
        return convertedGrokMatchPattern.toString();
    }

    private static String getConvertedMatchPattern(String matchPatternGroup) {
        int secondSeparatorIndex;
        StringBuilder convertedGrokMatchPatternGroup = new StringBuilder();
        int firstSeparatorIndex = matchPatternGroup.indexOf(SEPARATOR);
        if (firstSeparatorIndex != (secondSeparatorIndex = matchPatternGroup.lastIndexOf(SEPARATOR))) {
            String nestedField = matchPatternGroup.substring(firstSeparatorIndex + 1, secondSeparatorIndex);
            String convertedMatchPatternGroup = NestedSyntaxConverter.convertNestedSyntaxToJsonPointer(nestedField);
            convertedGrokMatchPatternGroup.append(matchPatternGroup, 0, firstSeparatorIndex + 1);
            convertedGrokMatchPatternGroup.append(convertedMatchPatternGroup);
            convertedGrokMatchPatternGroup.append(matchPatternGroup.substring(secondSeparatorIndex));
        } else if (firstSeparatorIndex != -1) {
            String nestedField = matchPatternGroup.substring(firstSeparatorIndex + 1, matchPatternGroup.indexOf("}"));
            String convertedMatchPatternGroup = NestedSyntaxConverter.convertNestedSyntaxToJsonPointer(nestedField);
            convertedGrokMatchPatternGroup.append(matchPatternGroup, 0, firstSeparatorIndex + 1);
            convertedGrokMatchPatternGroup.append(convertedMatchPatternGroup);
            convertedGrokMatchPatternGroup.append(matchPatternGroup.substring(matchPatternGroup.lastIndexOf("}")));
        }
        if (convertedGrokMatchPatternGroup.toString().isEmpty()) {
            return matchPatternGroup;
        }
        return convertedGrokMatchPatternGroup.toString();
    }
}

