/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.lang.reflect.Constructor;
import org.opensearch.dataprepper.logstash.exception.LogstashMappingException;
import org.opensearch.dataprepper.logstash.mapping.LogstashPluginAttributesMapper;

class AttributesMapperCreator {
    AttributesMapperCreator() {
    }

    LogstashPluginAttributesMapper createMapperClass(String attributesMapperClassName) {
        Class<?> attributesMapperClass;
        try {
            attributesMapperClass = Class.forName(attributesMapperClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new LogstashMappingException("Unable to find Mapper class with name of " + attributesMapperClassName, ex);
        }
        if (!LogstashPluginAttributesMapper.class.isAssignableFrom(attributesMapperClass)) {
            throw new LogstashMappingException("The provided mapping class does not implement " + String.valueOf(LogstashPluginAttributesMapper.class));
        }
        try {
            Constructor<?> defaultConstructor = attributesMapperClass.getDeclaredConstructor(new Class[0]);
            Object instance = defaultConstructor.newInstance(new Object[0]);
            return (LogstashPluginAttributesMapper)instance;
        }
        catch (Exception ex) {
            throw new LogstashMappingException("Unable to create Mapper class with name of " + attributesMapperClassName, ex);
        }
    }
}

