/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.SelectEntriesProcessorConfig;

@DataPrepperPlugin(name="select_entries", pluginType=Processor.class, pluginConfigurationType=SelectEntriesProcessorConfig.class)
public class SelectEntriesProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private final List<String> keysToInclude;
    private final String selectWhen;
    private final ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public SelectEntriesProcessor(PluginMetrics pluginMetrics, SelectEntriesProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.selectWhen = config.getSelectWhen();
        if (this.selectWhen != null && !expressionEvaluator.isValidExpressionStatement(this.selectWhen).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("select_when value of %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax.", this.selectWhen));
        }
        this.keysToInclude = config.getIncludeKeys();
        this.expressionEvaluator = expressionEvaluator;
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            if (Objects.nonNull(this.selectWhen) && !this.expressionEvaluator.evaluateConditional(this.selectWhen, recordEvent).booleanValue()) continue;
            HashMap<String, Object> outMap = new HashMap<String, Object>();
            for (String string : this.keysToInclude) {
                Object value = recordEvent.get(string, Object.class);
                if (value == null) continue;
                outMap.put(string, value);
            }
            recordEvent.clear();
            for (Map.Entry entry : outMap.entrySet()) {
                recordEvent.put((String)entry.getKey(), entry.getValue());
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

